/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.internal.zipkin.internal.Util;
import java.util.BitSet;
import java.util.Random;

public final class CountingSampler
extends Sampler {
    private int i;
    private final BitSet sampleDecisions;

    public static Sampler create(float rate) {
        if (rate == 0.0f) {
            return NEVER_SAMPLE;
        }
        if ((double)rate == 1.0) {
            return ALWAYS_SAMPLE;
        }
        Util.checkArgument(rate >= 0.01f && rate < 1.0f, "rate should be between 0.01 and 1: was %s", Float.valueOf(rate));
        return new CountingSampler(rate);
    }

    CountingSampler(float rate) {
        int outOf100 = (int)(rate * 100.0f);
        this.sampleDecisions = CountingSampler.randomBitSet(100, outOf100, new Random());
    }

    @Override
    public synchronized boolean isSampled(long traceIdIgnored) {
        boolean result = this.sampleDecisions.get(this.i++);
        if (this.i == 100) {
            this.i = 0;
        }
        return result;
    }

    public String toString() {
        return "CountingSampler()";
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

