/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

public class IdConversion {
    public static String convertToString(long id) {
        return Long.toHexString(id);
    }

    public static long convertToLong(String id) {
        if (id.length() == 0 || id.length() > 16) {
            throw new NumberFormatException(id + " should be a <=16 character lower-hex string with no prefix");
        }
        long result = 0L;
        for (char c : id.toCharArray()) {
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
                continue;
            }
            throw new NumberFormatException("character " + c + " not lower hex in " + id);
        }
        return result;
    }
}

