/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Span;
import java.nio.ByteBuffer;

public final class SpanId {
    public static final int FLAG_DEBUG = 1;
    public static final int FLAG_SAMPLING_SET = 2;
    public static final int FLAG_SAMPLED = 4;
    public static final int FLAG_IS_ROOT = 8;
    public final long traceId;
    public final long parentId;
    public final long spanId;
    public final long flags;
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static SpanId create(long traceId, long spanId, @Nullable Long parentSpanId) {
        return SpanId.builder().traceId(traceId).parentId(parentSpanId).spanId(spanId).build();
    }

    public SpanId(long traceId, long parentId, long spanId, long flags) {
        this.traceId = parentId == traceId ? parentId : traceId;
        this.parentId = parentId == spanId ? traceId : parentId;
        this.spanId = spanId;
        this.flags = flags;
    }

    public static SpanId fromBytes(byte[] bytes) {
        Util.checkNotNull(bytes, "bytes", new Object[0]);
        if (bytes.length != 32) {
            throw new IllegalArgumentException("bytes.length " + bytes.length + " != 32");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long spanId = buffer.getLong(0);
        long parentId = buffer.getLong(8);
        long traceId = buffer.getLong(16);
        long flags = buffer.getLong(24);
        return new SpanId(traceId, parentId, spanId, flags);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public long getTraceId() {
        return this.traceId;
    }

    @Deprecated
    public long getSpanId() {
        return this.spanId;
    }

    @Deprecated
    @Nullable
    public Long getParentSpanId() {
        return this.nullableParentId();
    }

    @Nullable
    public Long nullableParentId() {
        return this.root() ? null : Long.valueOf(this.parentId);
    }

    public final boolean root() {
        return (this.flags & 8L) == 8L || this.parentId == this.traceId && this.parentId == this.spanId;
    }

    public final boolean debug() {
        return (this.flags & 1L) == 1L;
    }

    @Nullable
    public final Boolean sampled() {
        if (this.debug()) {
            return true;
        }
        return (this.flags & 2L) == 2L ? Boolean.valueOf((this.flags & 4L) == 4L) : null;
    }

    public byte[] bytes() {
        byte[] result = new byte[32];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.putLong(0, this.spanId);
        buffer.putLong(8, this.parentId);
        buffer.putLong(16, this.traceId);
        buffer.putLong(24, this.flags);
        return result;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        char[] result = new char[51];
        SpanId.writeHexLong(result, 0, this.traceId);
        result[16] = 46;
        SpanId.writeHexLong(result, 17, this.spanId);
        result[33] = 60;
        result[34] = 58;
        SpanId.writeHexLong(result, 35, this.parentId);
        return new String(result);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpanId) {
            SpanId that = (SpanId)o;
            return this.traceId == that.traceId && this.parentId == that.parentId && this.spanId == that.spanId;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.traceId >>> 32 ^ this.traceId));
        h *= 1000003;
        h = (int)((long)h ^ (this.parentId >>> 32 ^ this.parentId));
        h *= 1000003;
        h = (int)((long)h ^ (this.spanId >>> 32 ^ this.spanId));
        return h;
    }

    public Span toSpan() {
        Span result = new Span();
        result.setId(this.spanId);
        result.setTrace_id(this.traceId);
        result.setParent_id(this.nullableParentId());
        if (this.debug()) {
            result.setDebug(this.debug());
        }
        return result;
    }

    static void writeHexLong(char[] data, int pos, long v) {
        SpanId.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        SpanId.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        SpanId.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        SpanId.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        SpanId.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        SpanId.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        SpanId.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        SpanId.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    public static final class Builder {
        Long traceId;
        Long parentId;
        Long spanId;
        long flags;

        Builder() {
        }

        Builder(SpanId source) {
            this.traceId = source.traceId;
            this.parentId = source.nullableParentId();
            this.spanId = source.spanId;
            this.flags = source.flags;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parentId(@Nullable Long parentId) {
            this.flags = parentId == null ? (this.flags |= 8L) : (this.flags &= 0xFFFFFFFFFFFFFFF7L);
            this.parentId = parentId;
            return this;
        }

        public Builder spanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder flags(long flags) {
            this.flags = flags;
            return this;
        }

        public Builder debug(boolean debug) {
            this.flags = debug ? (this.flags |= 1L) : (this.flags &= 0xFFFFFFFFFFFFFFFEL);
            return this;
        }

        public Builder sampled(@Nullable Boolean sampled) {
            if (sampled != null) {
                this.flags |= 2L;
                this.flags = sampled.booleanValue() ? (this.flags |= 4L) : (this.flags &= 0xFFFFFFFFFFFFFFFBL);
            } else {
                this.flags &= 0xFFFFFFFFFFFFFFFDL;
            }
            return this;
        }

        public SpanId build() {
            long traceId = this.traceId != null ? this.traceId : Util.checkNotNull(this.spanId, "spanId", new Object[0]);
            long parentId = this.parentId != null ? this.parentId : traceId;
            return new SpanId(traceId, parentId, Util.checkNotNull(this.spanId, "spanId", new Object[0]), this.flags);
        }
    }
}

