/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal.zipkin;

import com.github.kristofa.brave.internal.zipkin.internal.JsonCodec;
import com.github.kristofa.brave.internal.zipkin.internal.Util;

public final class DependencyLink {
    public final String parent;
    public final String child;
    public final long callCount;

    public static DependencyLink create(String parent, String child, long callCount) {
        return new DependencyLink(parent, child, callCount);
    }

    DependencyLink(String parent, String child, long callCount) {
        this.parent = Util.checkNotNull(parent, "parent").toLowerCase();
        this.child = Util.checkNotNull(child, "child").toLowerCase();
        this.callCount = callCount;
    }

    public String toString() {
        return JsonCodec.DEPENDENCY_LINK_ADAPTER.toJson(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DependencyLink) {
            DependencyLink that = (DependencyLink)o;
            return this.parent.equals(that.parent) && this.child.equals(that.child) && this.callCount == that.callCount;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.parent.hashCode();
        h *= 1000003;
        h ^= this.child.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.callCount >>> 32 ^ this.callCount));
        return h;
    }

    public static final class Builder {
        private String parent;
        private String child;
        private long callCount;

        public Builder() {
        }

        public Builder(DependencyLink source) {
            this.parent = source.parent;
            this.child = source.child;
            this.callCount = source.callCount;
        }

        public Builder parent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder child(String child) {
            this.child = child;
            return this;
        }

        public Builder callCount(long callCount) {
            this.callCount = callCount;
            return this;
        }

        public DependencyLink build() {
            return new DependencyLink(this.parent, this.child, this.callCount);
        }
    }
}

