/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal.zipkin;

import com.github.kristofa.brave.internal.zipkin.internal.JsonCodec;
import com.github.kristofa.brave.internal.zipkin.internal.Nullable;
import com.github.kristofa.brave.internal.zipkin.internal.Util;
import java.util.Locale;

public final class Endpoint {
    public final String serviceName;
    public final int ipv4;
    @Nullable
    public final Short port;

    public static Endpoint create(String serviceName, int ipv4, int port) {
        return new Endpoint(serviceName, ipv4, port == 0 ? null : Short.valueOf((short)(port & 0xFFFF)));
    }

    public static Endpoint create(String serviceName, int ipv4) {
        return new Endpoint(serviceName, ipv4, null);
    }

    Endpoint(String serviceName, int ipv4, Short port) {
        this.serviceName = Util.checkNotNull(serviceName, "serviceName").isEmpty() ? "" : serviceName.toLowerCase(Locale.ROOT);
        this.ipv4 = ipv4;
        this.port = port;
    }

    public String toString() {
        return JsonCodec.ENDPOINT_ADAPTER.toJson(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Endpoint) {
            Endpoint that = (Endpoint)o;
            return this.serviceName.equals(that.serviceName) && this.ipv4 == that.ipv4 && Util.equal(this.port, that.port);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.serviceName.hashCode();
        h *= 1000003;
        h ^= this.ipv4;
        h *= 1000003;
        return h ^= this.port == null ? 0 : this.port.hashCode();
    }

    public static final class Builder {
        private String serviceName;
        private Integer ipv4;
        private Short port;

        public Builder() {
        }

        public Builder(Endpoint source) {
            this.serviceName = source.serviceName;
            this.ipv4 = source.ipv4;
            this.port = source.port;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            return this;
        }

        public Builder port(Short port) {
            if (port == null || port != 0) {
                this.port = port;
            }
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.serviceName, this.ipv4, this.port);
        }
    }
}

