/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal.zipkin.internal;

import com.github.kristofa.brave.internal.zipkin.Annotation;
import com.github.kristofa.brave.internal.zipkin.BinaryAnnotation;
import com.github.kristofa.brave.internal.zipkin.Codec;
import com.github.kristofa.brave.internal.zipkin.DependencyLink;
import com.github.kristofa.brave.internal.zipkin.Endpoint;
import com.github.kristofa.brave.internal.zipkin.Span;
import com.github.kristofa.brave.internal.zipkin.internal.Util;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonAdapter;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonDataException;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonReader;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonWriter;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.Moshi;
import com.github.kristofa.brave.internal.zipkin.internal.okio.Buffer;
import com.github.kristofa.brave.internal.zipkin.internal.okio.ByteString;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class JsonCodec
implements Codec {
    static final JsonAdapter<Long> HEX_LONG_ADAPTER = new JsonAdapter<Long>(){

        @Override
        public Long fromJson(JsonReader reader) throws IOException {
            Buffer buffer = new Buffer();
            buffer.writeUtf8(reader.nextString());
            return buffer.readHexadecimalUnsignedLong();
        }

        @Override
        public void toJson(JsonWriter writer, Long value) throws IOException {
            writer.value(String.format("%016x", value));
        }
    };
    public static final JsonAdapter<Endpoint> ENDPOINT_ADAPTER = new JsonAdapter<Endpoint>(){

        @Override
        public Endpoint fromJson(JsonReader reader) throws IOException {
            Endpoint.Builder result = new Endpoint.Builder();
            reader.beginObject();
            block10: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "serviceName": {
                        result.serviceName(reader.nextString());
                        continue block10;
                    }
                    case "ipv4": {
                        String[] ipv4String = reader.nextString().split("\\.", 5);
                        int ipv4 = 0;
                        for (String b : ipv4String) {
                            ipv4 = ipv4 << 8 | Integer.parseInt(b) & 0xFF;
                        }
                        result.ipv4(ipv4);
                        continue block10;
                    }
                    case "port": {
                        result.port((short)reader.nextInt());
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public void toJson(JsonWriter writer, Endpoint value) throws IOException {
            int port;
            writer.beginObject();
            writer.name("serviceName").value(value.serviceName);
            String ipv4 = String.format("%d.%d.%d.%d", value.ipv4 >> 24 & 0xFF, value.ipv4 >> 16 & 0xFF, value.ipv4 >> 8 & 0xFF, value.ipv4 & 0xFF);
            writer.name("ipv4").value(ipv4);
            if (value.port != null && (port = value.port & 0xFFFF) != 0) {
                writer.name("port").value(port);
            }
            writer.endObject();
        }
    };
    public static final JsonAdapter<Annotation> ANNOTATION_ADAPTER = new Moshi.Builder().add((Type)((Object)Endpoint.class), ENDPOINT_ADAPTER.nullSafe()).build().adapter(Annotation.class);
    public static final JsonAdapter<BinaryAnnotation> BINARY_ANNOTATION_ADAPTER = new JsonAdapter<BinaryAnnotation>(){

        @Override
        public BinaryAnnotation fromJson(JsonReader reader) throws IOException {
            BinaryAnnotation.Builder result = new BinaryAnnotation.Builder();
            Double number = null;
            String string = null;
            BinaryAnnotation.Type type = BinaryAnnotation.Type.STRING;
            reader.beginObject();
            block28: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "key": {
                        result.key(reader.nextString());
                        continue block28;
                    }
                    case "value": {
                        switch (reader.peek()) {
                            case BOOLEAN: {
                                byte[] byArray;
                                type = BinaryAnnotation.Type.BOOL;
                                if (reader.nextBoolean()) {
                                    byte[] byArray2 = new byte[1];
                                    byArray = byArray2;
                                    byArray2[0] = 1;
                                } else {
                                    byte[] byArray3 = new byte[1];
                                    byArray = byArray3;
                                    byArray3[0] = 0;
                                }
                                result.value(byArray);
                                continue block28;
                            }
                            case STRING: {
                                string = reader.nextString();
                                continue block28;
                            }
                            case NUMBER: {
                                number = reader.nextDouble();
                                continue block28;
                            }
                        }
                        throw new JsonDataException("Expected value to be a boolean, string or number but was " + (Object)((Object)reader.peek()) + " at path " + reader.getPath());
                    }
                    case "type": {
                        type = BinaryAnnotation.Type.valueOf(reader.nextString());
                        continue block28;
                    }
                    case "endpoint": {
                        result.endpoint(ENDPOINT_ADAPTER.fromJson(reader));
                        continue block28;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            result.type(type);
            switch (type) {
                case BOOL: {
                    return result.build();
                }
                case STRING: {
                    return result.value(string.getBytes(Util.UTF_8)).build();
                }
                case BYTES: {
                    return result.value(ByteString.decodeBase64(string).toByteArray()).build();
                }
            }
            Buffer buffer = new Buffer();
            switch (type) {
                case I16: {
                    buffer.writeShort(number.shortValue());
                    break;
                }
                case I32: {
                    buffer.writeInt(number.intValue());
                    break;
                }
                case I64: {
                    buffer.writeLong(number.longValue());
                    break;
                }
                case DOUBLE: {
                    buffer.writeLong(Double.doubleToRawLongBits(number));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("BinaryAnnotationType " + (Object)((Object)type) + " was added, but not handled"));
                }
            }
            return result.value(buffer.readByteArray()).build();
        }

        @Override
        public void toJson(JsonWriter writer, BinaryAnnotation value) throws IOException {
            writer.beginObject();
            writer.name("key").value(value.key);
            writer.name("value");
            switch (value.type) {
                case BOOL: {
                    writer.value(value.value[0] == 1);
                    break;
                }
                case STRING: {
                    writer.value(new String(value.value, Util.UTF_8));
                    break;
                }
                case BYTES: {
                    writer.value(new Buffer().write(value.value).readByteString().base64Url());
                    break;
                }
                case I16: {
                    writer.value(new Buffer().write(value.value).readShort());
                    break;
                }
                case I32: {
                    writer.value(new Buffer().write(value.value).readInt());
                    break;
                }
                case I64: {
                    writer.value(new Buffer().write(value.value).readLong());
                    break;
                }
                case DOUBLE: {
                    writer.value(Double.longBitsToDouble(new Buffer().write(value.value).readLong()));
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                writer.name("type").value(value.type.name());
            }
            if (value.endpoint != null) {
                writer.name("endpoint");
                ENDPOINT_ADAPTER.toJson(writer, value.endpoint);
            }
            writer.endObject();
        }
    };
    public static final JsonAdapter<Span> SPAN_ADAPTER = new JsonAdapter<Span>(){

        @Override
        public Span fromJson(JsonReader reader) throws IOException {
            Span.Builder result = new Span.Builder();
            reader.beginObject();
            block22: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "traceId": {
                        result.traceId(HEX_LONG_ADAPTER.fromJson(reader));
                        continue block22;
                    }
                    case "name": {
                        result.name(reader.nextString());
                        continue block22;
                    }
                    case "id": {
                        result.id(HEX_LONG_ADAPTER.fromJson(reader));
                        continue block22;
                    }
                    case "parentId": {
                        result.parentId(HEX_LONG_ADAPTER.fromJson(reader));
                        continue block22;
                    }
                    case "timestamp": {
                        result.timestamp(reader.nextLong());
                        continue block22;
                    }
                    case "duration": {
                        result.duration(reader.nextLong());
                        continue block22;
                    }
                    case "annotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            result.addAnnotation(ANNOTATION_ADAPTER.fromJson(reader));
                        }
                        reader.endArray();
                        continue block22;
                    }
                    case "binaryAnnotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            result.addBinaryAnnotation(BINARY_ANNOTATION_ADAPTER.fromJson(reader));
                        }
                        reader.endArray();
                        continue block22;
                    }
                    case "debug": {
                        result.debug(reader.nextBoolean());
                        continue block22;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public void toJson(JsonWriter writer, Span value) throws IOException {
            int i;
            writer.beginObject();
            writer.name("traceId");
            HEX_LONG_ADAPTER.toJson(writer, (Long)value.traceId);
            writer.name("name").value(value.name);
            writer.name("id");
            HEX_LONG_ADAPTER.toJson(writer, (Long)value.id);
            if (value.parentId != null) {
                writer.name("parentId");
                HEX_LONG_ADAPTER.toJson(writer, value.parentId);
            }
            if (value.timestamp != null) {
                writer.name("timestamp").value(value.timestamp);
            }
            if (value.duration != null) {
                writer.name("duration").value(value.duration);
            }
            writer.name("annotations");
            writer.beginArray();
            int length = value.annotations.size();
            for (i = 0; i < length; ++i) {
                ANNOTATION_ADAPTER.toJson(writer, value.annotations.get(i));
            }
            writer.endArray();
            writer.name("binaryAnnotations");
            writer.beginArray();
            length = value.binaryAnnotations.size();
            for (i = 0; i < length; ++i) {
                BINARY_ANNOTATION_ADAPTER.toJson(writer, value.binaryAnnotations.get(i));
            }
            writer.endArray();
            if (value.debug != null) {
                writer.name("debug").value(value.debug);
            }
            writer.endObject();
        }

        public String toString() {
            return "Span";
        }
    };
    public static final JsonAdapter<DependencyLink> DEPENDENCY_LINK_ADAPTER = new JsonAdapter<DependencyLink>(){

        @Override
        public DependencyLink fromJson(JsonReader reader) throws IOException {
            DependencyLink.Builder result = new DependencyLink.Builder();
            reader.beginObject();
            block10: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "parent": {
                        result.parent(reader.nextString());
                        continue block10;
                    }
                    case "child": {
                        result.child(reader.nextString());
                        continue block10;
                    }
                    case "callCount": {
                        result.callCount(reader.nextLong());
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        @Override
        public void toJson(JsonWriter writer, DependencyLink value) throws IOException {
            writer.beginObject();
            writer.name("parent").value(value.parent);
            writer.name("child").value(value.child);
            writer.name("callCount").value(value.callCount);
            writer.endObject();
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final JsonAdapter<String> STRING_ADAPTER = new JsonAdapter<String>(){

        @Override
        public String fromJson(JsonReader reader) throws IOException {
            return reader.nextString();
        }

        @Override
        public void toJson(JsonWriter writer, String value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "String";
        }
    };

    @Override
    public Span readSpan(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading Span", new Object[0]);
        try {
            return SPAN_ADAPTER.fromJson(new Buffer().write(bytes));
        }
        catch (IOException | RuntimeException e) {
            throw JsonCodec.exceptionReading("Span", bytes, e);
        }
    }

    @Override
    public byte[] writeSpan(Span value) {
        Buffer buffer = new Buffer();
        JsonCodec.write(SPAN_ADAPTER, value, buffer);
        return buffer.readByteArray();
    }

    @Override
    public List<Span> readSpans(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<Span>", new Object[0]);
        return JsonCodec.readList(SPAN_ADAPTER, bytes);
    }

    @Override
    public byte[] writeSpans(List<Span> value) {
        return JsonCodec.writeList(SPAN_ADAPTER, value);
    }

    @Override
    public byte[] writeTraces(List<List<Span>> traces) {
        Buffer buffer = new Buffer();
        buffer.writeUtf8CodePoint(91);
        Iterator<List<Span>> trace = traces.iterator();
        while (trace.hasNext()) {
            buffer.writeUtf8CodePoint(91);
            Iterator<Span> span = trace.next().iterator();
            while (span.hasNext()) {
                JsonCodec.write(SPAN_ADAPTER, span.next(), buffer);
                if (!span.hasNext()) continue;
                buffer.writeUtf8CodePoint(44);
            }
            buffer.writeUtf8CodePoint(93);
            if (!trace.hasNext()) continue;
            buffer.writeUtf8CodePoint(44);
        }
        buffer.writeUtf8CodePoint(93);
        return buffer.readByteArray();
    }

    public List<List<Span>> readTraces(byte[] bytes) {
        JsonReader reader = JsonReader.of(new Buffer().write(bytes));
        LinkedList<List<Span>> result = new LinkedList<List<Span>>();
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginArray();
                LinkedList<Span> trace = new LinkedList<Span>();
                while (reader.hasNext()) {
                    trace.add(SPAN_ADAPTER.fromJson(reader));
                }
                reader.endArray();
                result.add(trace);
            }
            reader.endArray();
            return result;
        }
        catch (IOException | RuntimeException e) {
            throw JsonCodec.exceptionReading("List<List<Span>>", bytes, e);
        }
    }

    public DependencyLink readDependencyLink(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading DependencyLink", new Object[0]);
        try {
            return DEPENDENCY_LINK_ADAPTER.fromJson(new Buffer().write(bytes));
        }
        catch (IOException | RuntimeException e) {
            throw JsonCodec.exceptionReading("Span", bytes, e);
        }
    }

    public byte[] writeDependencyLink(DependencyLink value) {
        Buffer buffer = new Buffer();
        JsonCodec.write(DEPENDENCY_LINK_ADAPTER, value, buffer);
        return buffer.readByteArray();
    }

    @Override
    public List<DependencyLink> readDependencyLinks(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<DependencyLink>", new Object[0]);
        return JsonCodec.readList(DEPENDENCY_LINK_ADAPTER, bytes);
    }

    @Override
    public byte[] writeDependencyLinks(List<DependencyLink> value) {
        return JsonCodec.writeList(DEPENDENCY_LINK_ADAPTER, value);
    }

    public List<String> readStrings(byte[] bytes) {
        Util.checkArgument(bytes.length > 0, "Empty input reading List<String>", new Object[0]);
        return JsonCodec.readList(STRING_ADAPTER, bytes);
    }

    public byte[] writeStrings(List<String> value) {
        return JsonCodec.writeList(STRING_ADAPTER, value);
    }

    static <T> List<T> readList(JsonAdapter<T> adapter, byte[] bytes) {
        JsonReader reader = JsonReader.of(new Buffer().write(bytes));
        try {
            reader.beginArray();
            List result = reader.hasNext() ? new LinkedList() : Collections.emptyList();
            while (reader.hasNext()) {
                result.add(adapter.fromJson(reader));
            }
            reader.endArray();
            return result;
        }
        catch (IOException | RuntimeException e) {
            throw JsonCodec.exceptionReading("List<" + adapter + ">", bytes, e);
        }
    }

    static <T> byte[] writeList(JsonAdapter<T> adapter, List<T> values) {
        Buffer buffer = new Buffer();
        buffer.writeUtf8CodePoint(91);
        int length = values.size();
        int i = 0;
        while (i < length) {
            JsonCodec.write(adapter, values.get(i++), buffer);
            if (i >= length) continue;
            buffer.writeUtf8CodePoint(44);
        }
        buffer.writeUtf8CodePoint(93);
        return buffer.readByteArray();
    }

    static <T> void write(JsonAdapter<T> adapter, T value, Buffer buffer) {
        try {
            adapter.toJson(JsonWriter.of(buffer), value);
        }
        catch (IOException | RuntimeException e) {
            throw new AssertionError("Could not write " + value + " as json", e);
        }
    }

    static IllegalArgumentException exceptionReading(String type, byte[] bytes, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from json: %s", cause, type, new String(bytes, Util.UTF_8));
        throw new IllegalArgumentException(message, e);
    }
}

