/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal.zipkin.internal;

import com.github.kristofa.brave.internal.zipkin.internal.Nullable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;

public final class Util {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    static final Pattern HEX_ID_PATTERN = Pattern.compile("^[0-9a-f]{1,16}$");

    public static int envOr(String key, int fallback) {
        return System.getenv(key) != null ? Integer.parseInt(System.getenv(key)) : fallback;
    }

    public static String envOr(String key, String fallback) {
        return System.getenv(key) != null ? System.getenv(key) : fallback;
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static <T extends Comparable<? super T>> List<T> sortedList(@Nullable Collection<T> in) {
        if (in == null || in.isEmpty()) {
            return Collections.emptyList();
        }
        if (in.size() == 1) {
            return Collections.singletonList(in.iterator().next());
        }
        Object[] array = in.toArray();
        Arrays.sort(array);
        List<Object> result = Arrays.asList(array);
        return Collections.unmodifiableList(result);
    }

    public static long midnightUTC(long epochMillis) {
        Calendar day = Calendar.getInstance(UTC);
        day.setTimeInMillis(epochMillis);
        day.set(14, 0);
        day.set(13, 0);
        day.set(12, 0);
        day.set(11, 0);
        return day.getTimeInMillis();
    }

    public static long lowerHexToUnsignedLong(String lowerHex) {
        if (!HEX_ID_PATTERN.matcher(lowerHex).matches()) {
            throw new NumberFormatException(lowerHex + " should be a 1 to 16 character lower-hex string with no prefix");
        }
        long result = 0L;
        for (char c : lowerHex.toCharArray()) {
            result <<= 4;
            result |= c <= '9' ? (long)(c - 48) : (long)(c - 97 + 10);
        }
        return result;
    }

    private Util() {
    }
}

