/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.internal.zipkin.internal.moshi;

import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonAdapter;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonDataException;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonReader;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.JsonWriter;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.LinkedHashTreeMap;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.Moshi;
import com.github.kristofa.brave.internal.zipkin.internal.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

final class MapJsonAdapter<K, V>
extends JsonAdapter<Map<K, V>> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class<?> rawType = Types.getRawType(type);
            if (rawType != Map.class) {
                return null;
            }
            Type[] keyAndValue = Types.mapKeyAndValueTypes(type, rawType);
            return new MapJsonAdapter(moshi, keyAndValue[0], keyAndValue[1]).nullSafe();
        }
    };
    private final JsonAdapter<K> keyAdapter;
    private final JsonAdapter<V> valueAdapter;

    public MapJsonAdapter(Moshi moshi, Type keyType, Type valueType) {
        this.keyAdapter = moshi.adapter(keyType);
        this.valueAdapter = moshi.adapter(valueType);
    }

    @Override
    public void toJson(JsonWriter writer, Map<K, V> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at path " + writer.getPath());
            }
            writer.promoteNameToValue();
            this.keyAdapter.toJson(writer, entry.getKey());
            this.valueAdapter.toJson(writer, entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public Map<K, V> fromJson(JsonReader reader) throws IOException {
        LinkedHashTreeMap<K, V> result = new LinkedHashTreeMap<K, V>();
        reader.beginObject();
        while (reader.hasNext()) {
            V value;
            reader.promoteNameToValue();
            K name = this.keyAdapter.fromJson(reader);
            Object replaced = result.put(name, value = this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException("Map key '" + name + "' has multiple values at path " + reader.getPath());
        }
        reader.endObject();
        return result;
    }

    public String toString() {
        return "JsonAdapter(" + this.keyAdapter + "=" + this.valueAdapter + ")";
    }
}

