/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.api;

import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.api.IOpenAPI;
import com.github.kwai.open.request.GetAllSceneRequest;
import com.github.kwai.open.request.GetPushUrlResquest;
import com.github.kwai.open.request.PushStatusRequest;
import com.github.kwai.open.request.StopPushRequest;
import com.github.kwai.open.response.GetAllSceneResponse;
import com.github.kwai.open.response.GetPushUrlResponse;
import com.github.kwai.open.response.PushStatusResponse;
import com.github.kwai.open.response.StopPushResponse;
import com.github.kwai.open.utils.HttpUtils;
import com.github.kwai.open.utils.ValidatorUtils;

public class KwaiOpenLiveApi
implements IOpenAPI {
    private String appId = "";

    private KwaiOpenLiveApi(String appId) {
        this.appId = appId;
    }

    public static KwaiOpenLiveApi init(String appId) {
        return new KwaiOpenLiveApi(appId);
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    public GetPushUrlResponse getPushUrl(GetPushUrlResquest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.postMultipart("https://open.kuaishou.com/openapi/kwaiUser/live/pushUrls", request.toQueryParam(this), request.toFileParam(), GetPushUrlResponse.class);
    }

    public GetAllSceneResponse getAllScene(GetAllSceneRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/openapi/kwaiUser/live/scene", request.toQueryParam(this), GetAllSceneResponse.class);
    }

    public StopPushResponse stopPush(StopPushRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.postMultipart("https://open.kuaishou.com/openapi/kwaiUser/live/stopPush", request.toQueryParam(this), StopPushResponse.class);
    }

    public PushStatusResponse pushStatus(PushStatusRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/openapi/kwaiUser/live/status/" + request.getStreamName(), request.toQueryParam(this), PushStatusResponse.class);
    }
}

