/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.KwaiOpenResultCode;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T readValue(String jsonValue, Class<T> clazz) throws KwaiOpenException {
        try {
            Object result = objectMapper.readValue(jsonValue, clazz);
            return (T)result;
        }
        catch (Exception e) {
            throw new KwaiOpenException(KwaiOpenResultCode.SDK_ERROR, "JSON PARSE ERROR, json str:[" + jsonValue + "]", e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

