/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.utils;

import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.KwaiOpenResultCode;
import com.github.kwai.open.anotation.NotNull;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

public class ValidatorUtils {
    public static void valid(Object object) throws KwaiOpenException {
        Field[] fields;
        if (ValidatorUtils.isEmpty(object)) {
            return;
        }
        Class<?> cls = object.getClass();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(object);
                NotNull notNull = field.getAnnotation(NotNull.class);
                if (ValidatorUtils.isEmpty(notNull) || !ValidatorUtils.isEmpty(value)) continue;
                throw new KwaiOpenException(KwaiOpenResultCode.INVALID_REQUEST, notNull.errorMsg());
            }
            catch (KwaiOpenException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() == 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }
}

