/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Configuration;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.ExcludeColumn;
import com.github.liaochong.myexcel.core.annotation.IgnoreColumn;
import com.github.liaochong.myexcel.core.annotation.MultiColumn;
import com.github.liaochong.myexcel.core.constant.BooleanDropDownList;
import com.github.liaochong.myexcel.core.constant.Constants;
import com.github.liaochong.myexcel.core.constant.DropDownList;
import com.github.liaochong.myexcel.core.constant.File;
import com.github.liaochong.myexcel.core.constant.ImageFile;
import com.github.liaochong.myexcel.core.constant.LinkEmail;
import com.github.liaochong.myexcel.core.constant.LinkUrl;
import com.github.liaochong.myexcel.core.constant.NumberDropDownList;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.WriteConverterContext;
import com.github.liaochong.myexcel.core.converter.writer.LocalTimeWriteConverter;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.StyleParser;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.utils.ConfigurationUtil;
import com.github.liaochong.myexcel.utils.FieldDefinition;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.type.NullType;

abstract class AbstractSimpleExcelBuilder {
    protected List<String> fieldDisplayOrder;
    protected List<FieldDefinition> filteredFields = Collections.emptyList();
    protected List<String> titles;
    protected Map<Field, String> defaultValueMap = new HashMap<Field, String>();
    protected Map<Integer, Integer> customWidthMap = new HashMap<Integer, Integer>();
    protected int titleLevel = 0;
    private final Map<Integer, String> formats = new HashMap<Integer, String>();
    protected boolean isMapBuild;
    private final ConvertContext convertContext;
    protected Configuration configuration;
    private final Map<Field, ExcelColumnMapping> excelColumnMappingMap;
    protected StyleParser styleParser = new StyleParser(this.customWidthMap);
    protected boolean hasMultiColumn = false;

    public AbstractSimpleExcelBuilder(boolean isCsvBuild) {
        this.convertContext = new ConvertContext(isCsvBuild);
        this.configuration = this.convertContext.configuration;
        this.excelColumnMappingMap = this.convertContext.excelColumnMappingMap;
    }

    protected List<FieldDefinition> getFilteredFields(ClassFieldContainer classFieldContainer, Class<?> ... groups) {
        ConfigurationUtil.parseConfiguration(classFieldContainer, this.configuration);
        this.parseGlobalStyle();
        List<FieldDefinition> preElectionFields = this.getPreElectionFields(classFieldContainer);
        List<FieldDefinition> buildFields = this.getGroupFields(preElectionFields, groups);
        ArrayList<String> titles = new ArrayList<String>(buildFields.size());
        int size = buildFields.size();
        for (int i = 0; i < size; ++i) {
            FieldDefinition fieldDefinition2 = buildFields.get(i);
            Field field = fieldDefinition2.getField();
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            String[] columnStyles = null;
            if (excelColumn != null) {
                if (this.configuration.useFieldNameAsTitle && excelColumn.title().isEmpty()) {
                    titles.add(field.getName());
                } else {
                    titles.add(excelColumn.title());
                }
                if (!excelColumn.defaultValue().isEmpty()) {
                    this.defaultValueMap.put(field, excelColumn.defaultValue());
                }
                if (excelColumn.width() > -1) {
                    this.customWidthMap.putIfAbsent(i, excelColumn.width());
                }
                if (excelColumn.style().length > 0) {
                    columnStyles = excelColumn.style();
                }
                if (!excelColumn.format().isEmpty()) {
                    this.formats.put(i, excelColumn.format());
                } else if (!excelColumn.decimalFormat().isEmpty()) {
                    this.formats.put(i, excelColumn.decimalFormat());
                } else if (!excelColumn.dateFormatPattern().isEmpty()) {
                    this.formats.put(i, excelColumn.dateFormatPattern());
                }
                ExcelColumnMapping mapping = ExcelColumnMapping.mapping(excelColumn);
                this.excelColumnMappingMap.put(fieldDefinition2.getField(), mapping);
            } else if (this.configuration.useFieldNameAsTitle) {
                titles.add(field.getName());
            } else {
                titles.add(null);
            }
            this.styleParser.setColumnStyle(field, i, columnStyles);
            this.setGlobalFormat(i, field);
        }
        this.setTitles(titles);
        this.hasMultiColumn = buildFields.stream().anyMatch(fieldDefinition -> fieldDefinition.getField().isAnnotationPresent(MultiColumn.class));
        return buildFields;
    }

    protected void parseGlobalStyle() {
        this.styleParser.parse(this.configuration.style);
    }

    private void setGlobalFormat(int i, Field field) {
        if (this.formats.get(i) != null) {
            return;
        }
        if (field.getType() == LocalDate.class) {
            this.formats.put(i, this.configuration.dateFormat);
        } else if (ReflectUtil.isDate(field.getType())) {
            this.formats.put(i, this.configuration.dateTimeFormat);
        } else if (ReflectUtil.isNumber(field.getType()) && this.configuration.decimalFormat != null) {
            this.formats.put(i, this.configuration.decimalFormat);
        }
    }

    protected Table createTable() {
        Table table = new Table();
        table.caption = this.configuration.sheetName;
        table.trList = new LinkedList<Tr>();
        return table;
    }

    protected List<Tr> createThead() {
        if (this.titles == null || this.titles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList tdLists = new ArrayList();
        for (int i = 0; i < this.titles.size(); ++i) {
            String string = this.titles.get(i);
            if (string == null) continue;
            ArrayList<Td> tds = new ArrayList<Td>();
            String[] multiTitles = string.split(this.configuration.titleSeparator);
            if (multiTitles.length > this.titleLevel) {
                this.titleLevel = multiTitles.length;
            }
            for (int j = 0; j < multiTitles.length; ++j) {
                Td td2 = new Td(j, i);
                td2.th = true;
                td2.content = multiTitles[j];
                this.setPrompt(td2, i);
                this.setImage(td2, i);
                this.setDropdownList(td2, i);
                tds.add(td2);
            }
            tdLists.add(tds);
        }
        for (List list2 : tdLists) {
            Td last = (Td)list2.get(list2.size() - 1);
            last.setRowSpan(this.titleLevel - last.row);
        }
        int i = 0;
        while (i < this.titleLevel) {
            int n = i++;
            Map<String, List<List>> groups = tdLists.stream().filter(list -> list.size() > level).collect(Collectors.groupingBy(list -> ((Td)list.get((int)level)).content));
            groups.forEach((k, v) -> {
                if (v.size() == 1) {
                    return;
                }
                List tds = v.stream().map(list -> (Td)list.get(level)).sorted(Comparator.comparing(td -> td.col)).collect(Collectors.toList());
                LinkedList subTds = new LinkedList();
                Map<Integer, List<Td>> partitions = tds.stream().collect(Collectors.groupingBy(td -> td.rowSpan));
                partitions.forEach((col, subTdList) -> {
                    int splitIndex = 0;
                    int size = subTdList.size() - 1;
                    for (int j = 0; j < size; ++j) {
                        Td current = (Td)subTdList.get(j);
                        Td next = (Td)subTdList.get(j + 1);
                        if (current.col + 1 == next.col) continue;
                        List sub = subTdList.subList(splitIndex, j + 1);
                        splitIndex = j + 1;
                        if (sub.size() <= 1) continue;
                        subTds.add(sub);
                    }
                    subTds.add(subTdList.subList(splitIndex, subTdList.size()));
                });
                subTds.forEach(val -> {
                    if (val.size() == 1) {
                        return;
                    }
                    Td t = (Td)val.get(0);
                    t.setColSpan(val.size());
                    for (int j = 1; j < val.size(); ++j) {
                        ((Td)val.get((int)j)).row = -1;
                    }
                });
            });
        }
        Map<Integer, List<Td>> rowTds = tdLists.stream().flatMap(Collection::stream).filter(td -> td.row > -1).collect(Collectors.groupingBy(td -> td.row));
        ArrayList<Tr> arrayList = new ArrayList<Tr>();
        boolean isComputeAutoWidth = WidthStrategy.isComputeAutoWidth(this.configuration.widthStrategy);
        rowTds.forEach((k, v) -> {
            Tr tr = new Tr((int)k, this.configuration.titleRowHeight);
            tr.colWidthMap = isComputeAutoWidth || !this.customWidthMap.isEmpty() ? new HashMap(this.titles.size()) : Collections.emptyMap();
            tr.tdList = v.stream().sorted(Comparator.comparing(td -> td.col)).peek(td -> {
                if (isComputeAutoWidth) {
                    tr.colWidthMap.put(td.col, TdUtil.getStringWidth(td.content, 0.25));
                }
            }).collect(Collectors.toList());
            tr.colWidthMap.putAll(this.customWidthMap);
            trs.add(tr);
        });
        return arrayList;
    }

    protected Tr createTr(List<Pair<? extends Class, ?>> contents) {
        Tr tr = new Tr(0, this.configuration.rowHeight);
        if (contents.isEmpty()) {
            return tr;
        }
        tr.colWidthMap = new HashMap<Integer, Integer>();
        List tdList = IntStream.range(0, contents.size()).mapToObj(index -> {
            Td td = new Td(0, index);
            Pair pair = (Pair)contents.get(index);
            if (pair.getRepeatSize() != null) {
                td.setRowSpan(pair.getRepeatSize());
            }
            this.setTdContent(td, pair);
            this.setTdContentType(td, (Class)pair.getKey());
            if (this.isMapBuild) {
                this.setDateFormatForMap((Class)pair.getKey(), td);
            } else {
                td.format = this.formats.get(index);
                this.setFormula(index, td);
                this.setPrompt(td, index);
                this.setImage(td, index);
                this.setDropdownList(td, index);
            }
            this.setTdWidth(tr.colWidthMap, td);
            return td;
        }).collect(Collectors.toList());
        tr.colWidthMap.putAll(this.customWidthMap);
        tr.tdList = tdList;
        return tr;
    }

    private void setTdWidth(Map<Integer, Integer> colWidthMap, Td td) {
        if (!this.configuration.computeAutoWidth) {
            return;
        }
        if (td.format == null) {
            colWidthMap.put(td.col, TdUtil.getStringWidth(td.content));
        } else if (td.content != null && td.format.length() > td.content.length()) {
            colWidthMap.put(td.col, TdUtil.getStringWidth(td.format));
        } else if (td.date != null || td.localDate != null || td.localDateTime != null) {
            colWidthMap.put(td.col, TdUtil.getStringWidth(td.format, -0.15));
        }
    }

    private void setFormula(int i, Td td) {
        ExcelColumnMapping excelColumnMapping = this.getExcelColumnMapping(i);
        if (excelColumnMapping == null) {
            return;
        }
        if (excelColumnMapping.formula) {
            td.formula = true;
        }
    }

    protected void setPrompt(Td td, int index) {
        ExcelColumnMapping excelColumnMapping = this.getExcelColumnMapping(index);
        if (excelColumnMapping == null) {
            return;
        }
        if (excelColumnMapping.promptContainer != null) {
            td.promptContainer = excelColumnMapping.promptContainer;
        }
    }

    protected void setImage(Td td, int index) {
        ExcelColumnMapping excelColumnMapping = this.getExcelColumnMapping(index);
        if (excelColumnMapping == null) {
            return;
        }
        if (excelColumnMapping.image != null) {
            td.image = excelColumnMapping.image;
        }
    }

    protected void setDropdownList(Td td, int index) {
        ExcelColumnMapping excelColumnMapping = this.getExcelColumnMapping(index);
        if (excelColumnMapping == null) {
            return;
        }
        if (excelColumnMapping.dropdownList != null) {
            td.dropdownList = excelColumnMapping.dropdownList;
        }
    }

    private ExcelColumnMapping getExcelColumnMapping(int index) {
        if (this.filteredFields.isEmpty()) {
            return null;
        }
        FieldDefinition fieldDefinition = this.filteredFields.get(index);
        return this.excelColumnMappingMap.get(fieldDefinition.getField());
    }

    private void setTdContent(Td td, Pair<? extends Class, ?> pair) {
        Class fieldType = pair.getKey();
        if (fieldType == NullType.class) {
            return;
        }
        if (fieldType == Date.class) {
            td.date = (Date)pair.getValue();
        } else if (fieldType == LocalDateTime.class) {
            td.localDateTime = (LocalDateTime)pair.getValue();
        } else if (fieldType == LocalDate.class) {
            td.localDate = (LocalDate)pair.getValue();
        } else if (File.class.isAssignableFrom(fieldType)) {
            if (pair.getValue() instanceof java.io.File) {
                td.file = (java.io.File)pair.getValue();
            } else {
                td.fileIs = (InputStream)pair.getValue();
            }
        } else {
            td.content = String.valueOf(pair.getValue());
        }
    }

    private void setTdContentType(Td td, Class fieldType) {
        if (String.class == fieldType) {
            return;
        }
        if (ReflectUtil.isNumber(fieldType)) {
            td.tdContentType = ContentTypeEnum.DOUBLE;
            return;
        }
        if (ReflectUtil.isDate(fieldType)) {
            td.tdContentType = ContentTypeEnum.DATE;
            return;
        }
        if (ReflectUtil.isBool(fieldType)) {
            td.tdContentType = ContentTypeEnum.BOOLEAN;
            return;
        }
        if (fieldType == DropDownList.class) {
            td.tdContentType = ContentTypeEnum.DROP_DOWN_LIST;
            return;
        }
        if (fieldType == NumberDropDownList.class) {
            td.tdContentType = ContentTypeEnum.NUMBER_DROP_DOWN_LIST;
            return;
        }
        if (fieldType == BooleanDropDownList.class) {
            td.tdContentType = ContentTypeEnum.BOOLEAN_DROP_DOWN_LIST;
            return;
        }
        if (td.content != null && fieldType == LinkUrl.class) {
            td.tdContentType = ContentTypeEnum.LINK_URL;
            this.setLinkTd(td);
            return;
        }
        if (td.content != null && fieldType == LinkEmail.class) {
            td.tdContentType = ContentTypeEnum.LINK_EMAIL;
            this.setLinkTd(td);
            return;
        }
        if ((td.file != null || td.fileIs != null) && fieldType == ImageFile.class) {
            td.tdContentType = ContentTypeEnum.IMAGE;
        }
    }

    private void setLinkTd(Td td) {
        String[] splits = td.content.split("->");
        if (splits.length == 1) {
            td.link = td.content;
        } else {
            td.content = splits[0];
            td.link = splits[1];
        }
    }

    protected void setTitles(List<String> titles) {
        boolean hasTitle;
        if (this.titles == null && (hasTitle = titles.stream().anyMatch(StringUtil::isNotBlank))) {
            this.titles = titles;
        }
    }

    protected List<FieldDefinition> getGroupFields(List<FieldDefinition> preElectionFields, Class<?>[] groups) {
        List selectedGroupList = Objects.nonNull(groups) ? Arrays.stream(groups).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        return preElectionFields.stream().filter(fieldDefinition -> !fieldDefinition.getField().isAnnotationPresent(ExcludeColumn.class) && !fieldDefinition.getField().isAnnotationPresent(IgnoreColumn.class) && ReflectUtil.isFieldSelected(selectedGroupList, fieldDefinition)).sorted(ReflectUtil::sortFields).collect(Collectors.toList());
    }

    protected List<FieldDefinition> getPreElectionFields(ClassFieldContainer classFieldContainer) {
        if (Objects.nonNull(this.fieldDisplayOrder) && !this.fieldDisplayOrder.isEmpty()) {
            this.selfAdaption();
            return this.fieldDisplayOrder.stream().map(classFieldContainer::getFieldByName).collect(Collectors.toList());
        }
        List<Object> preElectionFields = this.configuration.includeAllField ? (this.configuration.excludeParent ? classFieldContainer.getDeclaredFields() : classFieldContainer.getFields()) : (this.configuration.excludeParent ? classFieldContainer.getDeclaredFields().stream().filter(fieldDefinition -> fieldDefinition.getField().isAnnotationPresent(ExcelColumn.class) || fieldDefinition.getField().isAnnotationPresent(MultiColumn.class)).collect(Collectors.toList()) : classFieldContainer.getFieldsByAnnotation(ExcelColumn.class, MultiColumn.class));
        if (this.configuration.ignoreStaticFields) {
            preElectionFields = preElectionFields.stream().filter(fieldDefinition -> !Modifier.isStatic(fieldDefinition.getField().getModifiers())).collect(Collectors.toList());
        }
        this.extractedMultiFieldDefinitions(preElectionFields);
        return preElectionFields;
    }

    private void extractedMultiFieldDefinitions(List<FieldDefinition> preElectionFields) {
        List multiFieldDefinitions = preElectionFields.stream().filter(preElectionField -> preElectionField.getField().isAnnotationPresent(MultiColumn.class) && preElectionField.getField().getType() != List.class).flatMap(preElectionField -> ReflectUtil.getWriteFieldDefinitionsOfExcelColumn(preElectionField.getField().getType()).stream().peek(fieldDefinition -> {
            if (fieldDefinition.getParentFields() == null || fieldDefinition.getParentFields().isEmpty()) {
                fieldDefinition.setParentFields(Collections.singletonList(preElectionField.getField()));
            } else {
                fieldDefinition.getParentFields().add(0, preElectionField.getField());
            }
        })).collect(Collectors.toList());
        if (multiFieldDefinitions.isEmpty()) {
            return;
        }
        preElectionFields.removeIf(preElectionField -> preElectionField.getField().isAnnotationPresent(MultiColumn.class) && preElectionField.getField().getType() != List.class);
        preElectionFields.addAll(multiFieldDefinitions);
    }

    private void selfAdaption() {
        if (this.titles == null || this.titles.isEmpty()) {
            return;
        }
        if (this.fieldDisplayOrder.size() > this.titles.size()) {
            int size = this.fieldDisplayOrder.size() - this.titles.size();
            for (int i = 0; i < size; ++i) {
                this.titles.add(null);
            }
        }
    }

    protected <T> List<List<Pair<? extends Class, ?>>> getMultiRenderContent(T data, List<FieldDefinition> sortedFields) {
        LinkedList<Pair<Class, ?>> convertResult = this.getOriginalRenderContent(data, sortedFields);
        int maxSize = convertResult.stream().filter(pair -> pair.getValue() instanceof List).map(pair -> ((List)pair.getValue()).size()).max(Integer::compareTo).orElse(1);
        LinkedList result = new LinkedList();
        for (int i = 0; i < maxSize; ++i) {
            LinkedList<Pair<Class, Object>> row = new LinkedList<Pair<Class, Object>>();
            for (Pair pair2 : convertResult) {
                if (!(pair2.getValue() instanceof List)) {
                    if (this.configuration.autoMerge) {
                        if (i == 0) {
                            pair2.setRepeatSize(maxSize);
                            row.add(pair2);
                            continue;
                        }
                        row.add(Pair.of(NullType.class, null));
                        continue;
                    }
                    row.add(pair2);
                    continue;
                }
                List list = (List)pair2.getValue();
                if (list.size() > i) {
                    row.add((Pair)list.get(i));
                    continue;
                }
                row.add(Constants.NULL_PAIR);
            }
            result.add(row);
        }
        return result;
    }

    protected <T> LinkedList<Pair<? extends Class, ?>> getOriginalRenderContent(T data, List<FieldDefinition> sortedFields) {
        return sortedFields.stream().map(field -> {
            Pair<? extends Class, Object> value = WriteConverterContext.convert(field, data, this.convertContext);
            if (value.getValue() != null) {
                return value;
            }
            String defaultValue = this.defaultValueMap.get(field);
            if (defaultValue != null) {
                return Pair.of(String.class, defaultValue);
            }
            if (this.configuration.defaultValue != null) {
                return Pair.of(String.class, this.configuration.defaultValue);
            }
            return value;
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    protected List<Pair<? extends Class, ?>> assemblingMapContents(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList contents = new ArrayList(data.size());
        if (this.fieldDisplayOrder == null) {
            data.forEach((k, v) -> this.doAddToContents(contents, v));
        } else {
            for (String fieldName : this.fieldDisplayOrder) {
                Object val = data.get(fieldName);
                this.doAddToContents(contents, val);
            }
        }
        return contents;
    }

    private void doAddToContents(List<Pair<? extends Class, ?>> contents, Object v) {
        if (v instanceof Pair && ((Pair)v).getKey() instanceof Class) {
            contents.add((Pair)v);
        } else if (v == null) {
            contents.add(Pair.of(NullType.class, null));
        } else if (v.getClass() == LocalTime.class) {
            contents.add(LocalTimeWriteConverter.doConvertDate((LocalTime)v, "HH:mm:ss"));
        } else {
            contents.add(Pair.of(v.getClass(), v));
        }
    }

    private void setDateFormatForMap(Class<?> objectClass, Td td) {
        if (objectClass == LocalDateTime.class || objectClass == Date.class) {
            td.format = "yyyy-MM-dd HH:mm:ss";
        } else if (objectClass == LocalDate.class) {
            td.format = "yyyy-MM-dd";
        }
    }
}

