/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractSimpleExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.HtmlToExcelStreamFactory;
import com.github.liaochong.myexcel.core.ListSupplier;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.SimpleStreamExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.core.templatehandler.TemplateHandler;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamExcelBuilder<T>
extends AbstractSimpleExcelBuilder
implements SimpleStreamExcelBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultStreamExcelBuilder.class);
    private final Class<T> dataType;
    private HtmlToExcelStreamFactory htmlToExcelStreamFactory;
    private Workbook workbook;
    private Path excel;
    private volatile boolean cancel;
    private Class<?>[] groups;
    private TemplateHandler templateHandler;
    private final List<CompletableFuture<Void>> asyncAppendFutures = new LinkedList<CompletableFuture<Void>>();
    private final HtmlToExcelStreamFactory.HtmlToExcelStreamFactoryContext context = new HtmlToExcelStreamFactory.HtmlToExcelStreamFactoryContext();

    private DefaultStreamExcelBuilder(Class<T> dataType) {
        this(dataType, (Workbook)null);
    }

    private DefaultStreamExcelBuilder(Class<T> dataType, Workbook workbook) {
        super(false);
        this.dataType = dataType;
        this.workbook = workbook;
        this.configuration.setWidthStrategy(WidthStrategy.NO_AUTO);
        this.isMapBuild = dataType == Map.class;
    }

    private DefaultStreamExcelBuilder(Class<T> dataType, Path excel) {
        super(false);
        this.dataType = dataType;
        this.excel = excel;
        this.configuration.setWidthStrategy(WidthStrategy.NO_AUTO);
        this.isMapBuild = dataType == Map.class;
    }

    public static <T> DefaultStreamExcelBuilder<T> of(Class<T> dataType) {
        return new DefaultStreamExcelBuilder<T>(dataType);
    }

    public static <T> DefaultStreamExcelBuilder<T> of(Class<T> dataType, Workbook workbook) {
        return new DefaultStreamExcelBuilder<T>(dataType, workbook);
    }

    public static <T> DefaultStreamExcelBuilder<T> of(Class<T> dataType, Path excel) {
        return new DefaultStreamExcelBuilder<T>(dataType, excel);
    }

    public static <T> DefaultStreamExcelBuilder<T> of(Class<T> dataType, InputStream excelInputStream) {
        return DefaultStreamExcelBuilder.of(dataType, TempFileOperator.convertToFile(excelInputStream));
    }

    public DefaultStreamExcelBuilder<T> titles(List<String> titles) {
        this.titles = titles;
        return this;
    }

    public DefaultStreamExcelBuilder<T> sheetName(String sheetName) {
        this.configuration.sheetName = sheetName;
        return this;
    }

    public DefaultStreamExcelBuilder<T> fieldDisplayOrder(List<String> fieldDisplayOrder) {
        this.fieldDisplayOrder = fieldDisplayOrder;
        return this;
    }

    public DefaultStreamExcelBuilder<T> workbookType(WorkbookType workbookType) {
        if (this.workbook != null) {
            throw new IllegalArgumentException("Workbook type confirmed, not modifiable");
        }
        this.configuration.workbookType = workbookType;
        return this;
    }

    public DefaultStreamExcelBuilder<T> noStyle() {
        this.styleParser.setNoStyle(true);
        return this;
    }

    public DefaultStreamExcelBuilder<T> widthStrategy(WidthStrategy widthStrategy) {
        this.configuration.setWidthStrategy(widthStrategy);
        return this;
    }

    @Deprecated
    public DefaultStreamExcelBuilder<T> autoWidthStrategy(AutoWidthStrategy autoWidthStrategy) {
        this.configuration.setWidthStrategy(AutoWidthStrategy.map(autoWidthStrategy));
        return this;
    }

    public DefaultStreamExcelBuilder<T> fixedTitles() {
        this.context.fixedTitles = true;
        return this;
    }

    public DefaultStreamExcelBuilder<T> widths(int ... widths) {
        for (int i = 0; i < widths.length; ++i) {
            this.customWidthMap.put(i, widths[i]);
        }
        return this;
    }

    public DefaultStreamExcelBuilder<T> width(int columnIndex, int width) {
        this.customWidthMap.put(columnIndex, width);
        return this;
    }

    public DefaultStreamExcelBuilder<T> hideColumns(int ... columnIndexs) {
        for (int columnIndex : columnIndexs) {
            this.width(columnIndex, 0);
        }
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> threadPool(ExecutorService executorService) {
        this.context.executorService = executorService;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> hasStyle() {
        this.styleParser.setNoStyle(false);
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> capacity(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
        this.context.capacity = capacity;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> pathConsumer(Consumer<Path> pathConsumer) {
        this.context.pathConsumer = pathConsumer;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> groups(Class<?> ... groups) {
        this.groups = groups;
        return this;
    }

    public DefaultStreamExcelBuilder<T> waitQueueSize(int waitQueueSize) {
        this.context.trWaitQueue = new LinkedBlockingQueue<Tr>(waitQueueSize);
        return this;
    }

    public DefaultStreamExcelBuilder<T> style(String ... styles) {
        this.styleParser.setNoStyle(false);
        this.configuration.style = Arrays.stream(styles).collect(Collectors.toSet());
        return this;
    }

    public DefaultStreamExcelBuilder<T> templateHandler(Class<? extends TemplateHandler> templateHandlerClass) {
        this.templateHandler = ReflectUtil.newInstance(templateHandlerClass);
        return this;
    }

    public DefaultStreamExcelBuilder<T> onStartSheet(Consumer<Sheet> startSheetConsumer) {
        this.context.startSheetConsumer = startSheetConsumer;
        return this;
    }

    public DefaultStreamExcelBuilder<T> freezePane(FreezePane freezePane) {
        this.context.freezePane = freezePane;
        return this;
    }

    public DefaultStreamExcelBuilder<T> titleRowHeight(int titleRowHeight) {
        this.configuration.titleRowHeight = titleRowHeight;
        return this;
    }

    public DefaultStreamExcelBuilder<T> rowHeight(int rowHeight) {
        this.configuration.rowHeight = rowHeight;
        return this;
    }

    public DefaultStreamExcelBuilder<T> binding(Object ... applicationBeans) {
        this.binding(new HashSet<Object>(Arrays.asList(applicationBeans)));
        return this;
    }

    public DefaultStreamExcelBuilder<T> binding(Set<Object> applicationBeans) {
        if (applicationBeans.isEmpty()) {
            log.warn("binding application beans failure");
            return this;
        }
        Map<Class, Object> map = applicationBeans.stream().collect(Collectors.toMap(Object::getClass, b -> b));
        this.configuration.applicationBeans = map;
        return this;
    }

    public DefaultStreamExcelBuilder<T> autoMerge() {
        this.configuration.autoMerge = true;
        return this;
    }

    public DefaultStreamExcelBuilder<T> nameManager(Map<String, List<?>> nameMapping) {
        this.configuration.nameMapping = nameMapping;
        return this;
    }

    @Override
    public DefaultStreamExcelBuilder<T> start() {
        if (this.isMapBuild) {
            this.parseGlobalStyle();
        } else {
            ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(this.dataType);
            this.filteredFields = this.getFilteredFields(classFieldContainer, this.groups);
        }
        this.context.styleParser = this.styleParser;
        this.htmlToExcelStreamFactory = new HtmlToExcelStreamFactory(this.context);
        this.htmlToExcelStreamFactory.widthStrategy(this.configuration.widthStrategy);
        this.htmlToExcelStreamFactory.nameManager(this.configuration.nameMapping);
        if (this.workbook == null) {
            this.htmlToExcelStreamFactory.workbookType(this.configuration.workbookType);
        }
        Table table = this.createTable();
        List<Tr> head = this.createThead();
        if (head != null) {
            this.htmlToExcelStreamFactory.appendTitles(head);
        }
        this.htmlToExcelStreamFactory.start(table, this.workbook);
        if (this.excel != null && Files.exists(this.excel, new LinkOption[0])) {
            log.info("start reading existing excel data.");
            SaxExcelReader<Object> reader = SaxExcelReader.of(this.dataType).readAllSheet();
            if (this.titleLevel > 0) {
                reader.rowFilter(row -> row.getRowNum() > this.titleLevel - 1);
            }
            reader.readThen(this.excel.toFile(), this::append);
        }
        return this;
    }

    @Override
    public void append(List<T> dataList) {
        if (this.cancel) {
            log.info("Canceled build task");
            return;
        }
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        for (T data : dataList) {
            this.append(data);
        }
    }

    @Override
    public void append(T data) {
        if (this.cancel) {
            log.info("Canceled build task");
            return;
        }
        if (data == null) {
            return;
        }
        if (this.isMapBuild) {
            List<Pair<? extends Class, ?>> contents = this.assemblingMapContents((Map)data);
            this.appendTr(contents);
            return;
        }
        if (this.hasMultiColumn) {
            List<List<Pair<Class, ?>>> contents = this.getMultiRenderContent(data, this.filteredFields);
            for (List<Pair<? extends Class, ?>> list : contents) {
                this.appendTr(list);
            }
        } else {
            LinkedList<Pair<? extends Class, ?>> contents = this.getOriginalRenderContent(data, this.filteredFields);
            this.appendTr(contents);
        }
    }

    private void appendTr(List<Pair<? extends Class, ?>> contents) {
        Tr tr = this.createTr(contents);
        this.htmlToExcelStreamFactory.append(tr);
    }

    public <E> void append(String templateFilePath, Map<String, E> renderData) {
        this.templateHandler.classpathTemplate(templateFilePath);
        this.doAppend(renderData);
    }

    public <E> void append(String templateDir, String templateFileName, Map<String, E> renderData) {
        this.templateHandler.fileTemplate(templateDir, templateFileName);
        this.doAppend(renderData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncAppend(ListSupplier<T> supplier) {
        CompletableFuture<Void> future = this.context.executorService == null ? CompletableFuture.runAsync(() -> this.append((T)supplier.getAsList())) : CompletableFuture.runAsync(() -> this.append((T)supplier.getAsList()), this.context.executorService);
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = this;
        synchronized (defaultStreamExcelBuilder) {
            this.asyncAppendFutures.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncAppend(Supplier<T> supplier) {
        CompletableFuture<Void> future = this.context.executorService == null ? CompletableFuture.runAsync(() -> this.append(supplier.get())) : CompletableFuture.runAsync(() -> this.append(supplier.get()), this.context.executorService);
        DefaultStreamExcelBuilder defaultStreamExcelBuilder = this;
        synchronized (defaultStreamExcelBuilder) {
            this.asyncAppendFutures.add(future);
        }
    }

    @Override
    public Workbook build() {
        this.joinAsyncAppendFutures();
        return this.htmlToExcelStreamFactory.build();
    }

    @Override
    public List<Path> buildAsPaths() {
        this.joinAsyncAppendFutures();
        return this.htmlToExcelStreamFactory.buildAsPaths();
    }

    @Override
    public Path buildAsZip(String fileName) {
        this.joinAsyncAppendFutures();
        return this.htmlToExcelStreamFactory.buildAsZip(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelStreamFactory != null) {
            this.htmlToExcelStreamFactory.clear();
            this.htmlToExcelStreamFactory = null;
        }
    }

    public void cancel() {
        this.cancel = true;
        this.htmlToExcelStreamFactory.cancel();
    }

    public void clear() {
        this.htmlToExcelStreamFactory.clear();
    }

    private <E> void doAppend(Map<String, E> renderData) {
        List<Table> tables;
        try {
            tables = this.templateHandler.render(renderData, new ParseConfig(this.configuration.widthStrategy));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (tables == null || tables.isEmpty()) {
            return;
        }
        for (Table table : tables) {
            table.trList.forEach(this.htmlToExcelStreamFactory::append);
        }
    }

    private void joinAsyncAppendFutures() {
        if (!this.asyncAppendFutures.isEmpty()) {
            this.asyncAppendFutures.forEach(CompletableFuture::join);
        }
    }
}

