/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractHSSFReadHandler;
import com.github.liaochong.myexcel.core.SheetMetaData;
import com.github.liaochong.myexcel.core.WorkbookMetaData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

class HSSFMetaDataSaxReadHandler
extends AbstractHSSFReadHandler {
    private int lastRowNumber = -1;
    private final WorkbookMetaData workbookMetaData;

    public HSSFMetaDataSaxReadHandler(File file, WorkbookMetaData workbookMetaData) throws IOException {
        this.fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
        this.workbookMetaData = workbookMetaData;
    }

    @Override
    public void process() throws IOException {
        super.process();
        if (this.lastRowNumber > -1) {
            this.workbookMetaData.getSheetMetaDataList().get(this.sheetIndex).setLastRowNum(this.lastRowNumber + 1);
        }
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                List<SheetMetaData> sheetMetaDataList = this.workbookMetaData.getSheetMetaDataList();
                if (this.lastRowNumber > -1) {
                    sheetMetaDataList.get(this.sheetIndex).setLastRowNum(this.lastRowNumber + 1);
                }
                ++this.sheetIndex;
                this.lastRowNumber = -1;
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition((List)this.boundSheetRecords);
                }
                String sheetName = this.orderedBSRs[this.sheetIndex].getSheetname();
                SheetMetaData sheetMetaData = new SheetMetaData(sheetName, this.sheetIndex);
                sheetMetaDataList.add(sheetMetaData);
                this.workbookMetaData.setSheetCount(this.sheetIndex + 1);
                break;
            }
            case 513: {
                thisRow = ((BlankRecord)record).getRow();
                break;
            }
            case 517: {
                thisRow = ((BoolErrRecord)record).getRow();
                break;
            }
            case 6: {
                thisRow = ((FormulaRecord)record).getRow();
                break;
            }
            case 516: {
                thisRow = ((LabelRecord)record).getRow();
                break;
            }
            case 253: {
                thisRow = ((LabelSSTRecord)record).getRow();
                break;
            }
            case 28: {
                thisRow = ((NoteRecord)record).getRow();
                break;
            }
            case 515: {
                thisRow = ((NumberRecord)record).getRow();
                break;
            }
            case 638: {
                thisRow = ((RKRecord)record).getRow();
                break;
            }
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            LastCellOfRowDummyRecord lc = (LastCellOfRowDummyRecord)record;
            thisRow = lc.getRow();
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastRowNumber = thisRow;
        }
    }
}

