/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.cache.StringsCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ReadOnlySharedStringsTable
extends DefaultHandler
implements SharedStrings {
    protected int count;
    private int uniqueCount;
    private final StringsCache stringsCache;
    private int stringIndex;
    private StringBuilder characters;
    private boolean tIsOpen;
    private boolean inRPh;

    public ReadOnlySharedStringsTable(OPCPackage pkg, StringsCache stringsCache) throws IOException, SAXException {
        this.stringsCache = stringsCache;
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public void readFrom(InputStream is) throws IOException, SAXException {
        PushbackInputStream pis = new PushbackInputStream(is, 1);
        int emptyTest = pis.read();
        if (emptyTest > -1) {
            pis.unread(emptyTest);
            try {
                XMLReader sheetParser = XMLHelper.newXMLReader();
                sheetParser.setContentHandler(this);
                sheetParser.parse(new InputSource(pis));
                this.stringsCache.finished();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public RichTextString getItemAt(int idx) {
        return new XSSFRichTextString(this.stringsCache.get(idx));
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("sst".equals(localName)) {
            String uniqueCount;
            String count = attributes.getValue("count");
            if (count != null) {
                this.count = Integer.parseInt(count);
            }
            if ((uniqueCount = attributes.getValue("uniqueCount")) != null) {
                this.uniqueCount = Integer.parseInt(uniqueCount);
            }
            this.characters = new StringBuilder(64);
            this.stringsCache.init(this.uniqueCount > 0 ? this.uniqueCount : this.count);
        } else if ("si".equals(localName)) {
            this.characters.setLength(0);
        } else if ("t".equals(localName)) {
            this.tIsOpen = true;
        } else if ("rPh".equals(localName)) {
            this.inRPh = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("si".equals(localName)) {
            this.stringsCache.cache(this.stringIndex++, this.characters.toString());
        } else if ("t".equals(localName)) {
            this.tIsOpen = false;
        } else if ("rPh".equals(localName)) {
            this.inRPh = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tIsOpen && !this.inRPh) {
            this.characters.append(ch, start, length);
        }
    }
}

