/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.annotation.MultiColumn;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.context.Hyperlink;
import com.github.liaochong.myexcel.core.context.ReadContext;
import com.github.liaochong.myexcel.core.converter.ReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.BigDecimalReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.BoolReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.DateReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.HyperlinkReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.LocalDateReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.LocalDateTimeReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.LocalTimeReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.NumberReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.StringReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.TimestampReadConverter;
import com.github.liaochong.myexcel.exception.ExcelReadException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import com.github.liaochong.myexcel.utils.FieldDefinition;
import com.github.liaochong.myexcel.utils.PropertyUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ReadConverterContext {
    private static final Map<Class<?>, ReadConverter<?>> READ_CONVERTERS = new HashMap();
    private static final WeakCache<Field, Properties> MAPPING_CACHE = new WeakCache();
    private static final Properties EMPTY_PROPERTIES = new Properties();

    public static boolean support(Class<?> clazz) {
        return READ_CONVERTERS.get(clazz) != null;
    }

    public synchronized ReadConverterContext registering(Class<?> clazz, ReadConverter<?> readConverter) {
        READ_CONVERTERS.putIfAbsent(clazz, readConverter);
        return this;
    }

    public static void convert(Object obj, ReadContext<?> readContext) {
        Object value;
        block14: {
            ReadConverter<?> readConverter = READ_CONVERTERS.get(readContext.getField().getType());
            if (readConverter == null) {
                MultiColumn multiColumn = readContext.getField().getAnnotation(MultiColumn.class);
                if (multiColumn != null) {
                    readConverter = READ_CONVERTERS.get(multiColumn.classType());
                }
                if (readConverter == null) {
                    throw new IllegalStateException("No suitable type converter was found,Field=" + readContext.getField().getName() + ".");
                }
            }
            value = null;
            try {
                String mappingVal;
                Properties properties = MAPPING_CACHE.get(readContext.getField());
                if (properties == null) {
                    ExcelColumnMapping mapping = readContext.convertContext.excelColumnMappingMap.get(readContext.getField());
                    properties = mapping != null && !mapping.mapping.isEmpty() ? PropertyUtil.getReverseProperties(mapping) : EMPTY_PROPERTIES;
                    MAPPING_CACHE.cache(readContext.getField(), properties);
                }
                if ((mappingVal = properties.getProperty(readContext.getVal())) != null) {
                    readContext.setVal(mappingVal);
                }
                value = readConverter.convert(readContext);
            }
            catch (Exception e) {
                Boolean toContinue = readContext.readConfig.exceptionFunction.apply(e, readContext);
                if (toContinue.booleanValue()) break block14;
                throw new ExcelReadException("Failed to convert content,field:[" + readContext.getField().getDeclaringClass().getName() + "#" + readContext.getField().getName() + "],content:[" + readContext.getVal() + "],rowNum:[" + readContext.getRowNum() + "]", e);
            }
        }
        if (value == null) {
            return;
        }
        try {
            if (obj instanceof List) {
                ((List)obj).add(value);
            } else {
                FieldDefinition fieldDefinition = readContext.getFieldDefinition();
                Method setMethod = fieldDefinition.getSetMethod();
                if (setMethod != null) {
                    setMethod.invoke(obj, value);
                } else {
                    fieldDefinition.getField().set(obj, value);
                }
            }
        }
        catch (Exception e) {
            throw new SaxReadException("Failed to set the " + readContext.getField().getDeclaringClass().getName() + "#" + readContext.getField().getName() + " field value to " + readContext.getVal(), e);
        }
    }

    static {
        READ_CONVERTERS.put(Hyperlink.class, new HyperlinkReadConverter());
        BoolReadConverter boolReadConverter = new BoolReadConverter();
        READ_CONVERTERS.put(Boolean.class, boolReadConverter);
        READ_CONVERTERS.put(Boolean.TYPE, boolReadConverter);
        READ_CONVERTERS.put(Date.class, new DateReadConverter());
        READ_CONVERTERS.put(LocalDate.class, new LocalDateReadConverter());
        READ_CONVERTERS.put(LocalDateTime.class, new LocalDateTimeReadConverter());
        READ_CONVERTERS.put(LocalTime.class, new LocalTimeReadConverter());
        NumberReadConverter<Double> doubleReadConverter = NumberReadConverter.of(Double::valueOf);
        READ_CONVERTERS.put(Double.class, doubleReadConverter);
        READ_CONVERTERS.put(Double.TYPE, doubleReadConverter);
        NumberReadConverter<Float> floatReadConverter = NumberReadConverter.of(Float::valueOf);
        READ_CONVERTERS.put(Float.class, floatReadConverter);
        READ_CONVERTERS.put(Float.TYPE, floatReadConverter);
        NumberReadConverter<Long> longReadConverter = NumberReadConverter.of(Long::valueOf, true);
        READ_CONVERTERS.put(Long.class, longReadConverter);
        READ_CONVERTERS.put(Long.TYPE, longReadConverter);
        NumberReadConverter<Integer> integerReadConverter = NumberReadConverter.of(Integer::valueOf, true);
        READ_CONVERTERS.put(Integer.class, integerReadConverter);
        READ_CONVERTERS.put(Integer.TYPE, integerReadConverter);
        NumberReadConverter<Short> shortReadConverter = NumberReadConverter.of(Short::valueOf, true);
        READ_CONVERTERS.put(Short.class, shortReadConverter);
        READ_CONVERTERS.put(Short.TYPE, shortReadConverter);
        NumberReadConverter<Byte> byteReadConverter = NumberReadConverter.of(Byte::valueOf, true);
        READ_CONVERTERS.put(Byte.class, byteReadConverter);
        READ_CONVERTERS.put(Byte.TYPE, byteReadConverter);
        READ_CONVERTERS.put(BigDecimal.class, new BigDecimalReadConverter());
        READ_CONVERTERS.put(String.class, new StringReadConverter());
        READ_CONVERTERS.put(Timestamp.class, new TimestampReadConverter());
        NumberReadConverter<BigInteger> bigIntegerReadConverter = NumberReadConverter.of(BigInteger::new, true);
        READ_CONVERTERS.put(BigInteger.class, bigIntegerReadConverter);
    }
}

