/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.reflect;

import com.github.liaochong.myexcel.utils.FieldDefinition;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ClassFieldContainer {
    private Class<?> clazz;
    private final List<FieldDefinition> declaredFields = new ArrayList<FieldDefinition>();
    private final Map<String, FieldDefinition> fieldMap = new HashMap<String, FieldDefinition>();
    private ClassFieldContainer parent;

    public FieldDefinition getFieldByName(String fieldName) {
        return this.getFieldByName(fieldName, this);
    }

    @SafeVarargs
    public final List<FieldDefinition> getFieldsByAnnotation(Class<? extends Annotation> ... annotationClazzs) {
        Objects.requireNonNull(annotationClazzs);
        ArrayList<FieldDefinition> annotationFields = new ArrayList<FieldDefinition>();
        this.getFieldsByAnnotation(this, annotationFields, annotationClazzs);
        return annotationFields;
    }

    public List<FieldDefinition> getFields() {
        ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        this.getFieldsByContainer(this, fields);
        return fields;
    }

    private void getFieldsByContainer(ClassFieldContainer classFieldContainer, List<FieldDefinition> fields) {
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (parentContainer != null) {
            this.getFieldsByContainer(parentContainer, fields);
        }
        this.filterFields(classFieldContainer.getDeclaredFields(), fields);
    }

    @SafeVarargs
    private final void getFieldsByAnnotation(ClassFieldContainer classFieldContainer, List<FieldDefinition> annotationFieldContainer, Class<? extends Annotation> ... annotationClazzs) {
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (parentContainer != null) {
            this.getFieldsByAnnotation(parentContainer, annotationFieldContainer, annotationClazzs);
        }
        List<FieldDefinition> annotationFields = classFieldContainer.declaredFields.stream().filter(fieldDefinition -> {
            for (Class annotationClazz : annotationClazzs) {
                boolean isAnnotationPresent = fieldDefinition.getField().isAnnotationPresent(annotationClazz);
                if (!isAnnotationPresent) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        this.filterFields(annotationFields, annotationFieldContainer);
    }

    private void filterFields(List<FieldDefinition> declaredFields, List<FieldDefinition> fieldDefinitionsContainer) {
        block0: for (FieldDefinition fieldDefinition : declaredFields) {
            for (int j = 0; j < fieldDefinitionsContainer.size(); ++j) {
                FieldDefinition f = fieldDefinitionsContainer.get(j);
                if (!f.getField().getName().equals(fieldDefinition.getField().getName())) continue;
                fieldDefinitionsContainer.set(j, fieldDefinition);
                continue block0;
            }
            fieldDefinitionsContainer.add(fieldDefinition);
        }
    }

    private FieldDefinition getFieldByName(String fieldName, ClassFieldContainer container) {
        FieldDefinition fieldDefinition = container.getFieldMap().get(fieldName);
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        ClassFieldContainer parentContainer = container.getParent();
        if (parentContainer == null) {
            return null;
        }
        return this.getFieldByName(fieldName, parentContainer);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<FieldDefinition> getDeclaredFields() {
        return this.declaredFields;
    }

    public Map<String, FieldDefinition> getFieldMap() {
        return this.fieldMap;
    }

    public ClassFieldContainer getParent() {
        return this.parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setParent(ClassFieldContainer parent) {
        this.parent = parent;
    }
}

