/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.utils.TempFileOperator;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class AttachmentV2ExportUtil {
    public static void export(Workbook workbook, String fileName, HttpServletResponse response) {
        try {
            String suffix = ".xlsx";
            if (workbook instanceof HSSFWorkbook) {
                if (fileName.endsWith(suffix)) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                suffix = ".xls";
                response.setContentType("application/vnd.ms-excel");
            } else {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            }
            if (!fileName.endsWith(suffix)) {
                fileName = fileName + suffix;
            }
            AttachmentV2ExportUtil.setAttachmentConfig(fileName, response);
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            AttachmentV2ExportUtil.clear(workbook);
        }
    }

    public static void encryptExport(Workbook workbook, String fileName, HttpServletResponse response, String password) {
        if (workbook instanceof HSSFWorkbook) {
            throw new IllegalArgumentException("Document encryption for.xls is not supported");
        }
        Path path = null;
        try {
            String suffix = ".xlsx";
            path = TempFileOperator.createTempFile("encrypt_temp", suffix);
            workbook.write(Files.newOutputStream(path, new OpenOption[0]));
            POIFSFileSystem fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.standard);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((File)path.toFile(), (PackageAccess)PackageAccess.READ_WRITE);
                 OutputStream os = enc.getDataStream(fs);){
                opc.save(os);
            }
            if (!fileName.endsWith(suffix)) {
                fileName = fileName + suffix;
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            AttachmentV2ExportUtil.setAttachmentConfig(fileName, response);
            fs.writeFilesystem((OutputStream)response.getOutputStream());
        }
        catch (IOException | GeneralSecurityException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        finally {
            AttachmentV2ExportUtil.clear(workbook);
            TempFileOperator.deleteTempFile(path);
        }
    }

    private static void clear(Workbook workbook) {
        if (workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)workbook).dispose();
        }
        try {
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void export(Path path, String fileName, HttpServletResponse response) {
        try {
            response.setContentType("application/octet-stream");
            AttachmentV2ExportUtil.setAttachmentConfig(fileName, response);
            response.getOutputStream().write(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            TempFileOperator.deleteTempFile(path);
        }
    }

    private static void setAttachmentConfig(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8").replace("+", "%20"));
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
    }
}

