/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ColumnSaxExcelReader {
    private final SaxExcelReader<Map> saxExcelReader = SaxExcelReader.of(Map.class);
    private final int columnNum;
    private boolean ignoreBlankCell;

    private ColumnSaxExcelReader(int columnNum) {
        this.columnNum = columnNum;
    }

    public static ColumnSaxExcelReader columnNum(int columnNum) {
        return new ColumnSaxExcelReader(columnNum);
    }

    public ColumnSaxExcelReader rowFilter(Predicate<Row> predicate) {
        this.saxExcelReader.rowFilter(predicate);
        return this;
    }

    public ColumnSaxExcelReader sheet(int sheetNum) {
        this.saxExcelReader.sheet(sheetNum);
        return this;
    }

    public ColumnSaxExcelReader sheet(String sheetName) {
        this.saxExcelReader.sheet(sheetName);
        return this;
    }

    public ColumnSaxExcelReader ignoreBlankCell() {
        this.saxExcelReader.ignoreBlankRow();
        this.ignoreBlankCell = true;
        return this;
    }

    public ColumnSaxExcelReader stopReadingOnBlankRow() {
        this.saxExcelReader.stopReadingOnBlankRow();
        return this;
    }

    public List<String> readAsString(InputStream inputStream) {
        List<Map> result = this.saxExcelReader.read(inputStream);
        return this.mapToString(result);
    }

    public List<String> readAsString(File file) {
        List<Map> result = this.saxExcelReader.read(file);
        return this.mapToString(result);
    }

    public List<Integer> readAsInteger(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Integer::valueOf);
    }

    public List<Integer> readAsInteger(File file) {
        return this.getList(this.saxExcelReader.read(file), Integer::valueOf);
    }

    public List<Long> readAsLong(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Long::valueOf);
    }

    public List<Long> readAsLong(File file) {
        return this.getList(this.saxExcelReader.read(file), Long::valueOf);
    }

    public List<Boolean> readAsBoolean(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Boolean::valueOf);
    }

    public List<Boolean> readAsBoolean(File file) {
        return this.getList(this.saxExcelReader.read(file), Boolean::valueOf);
    }

    public List<Double> readAsDouble(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Double::valueOf);
    }

    public List<Double> readAsDouble(File file) {
        return this.getList(this.saxExcelReader.read(file), Double::valueOf);
    }

    public List<Short> readAsShort(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Short::valueOf);
    }

    public List<Short> readAsShort(File file) {
        return this.getList(this.saxExcelReader.read(file), Short::valueOf);
    }

    public List<Float> readAsFloat(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Float::valueOf);
    }

    public List<Float> readAsFloat(File file) {
        return this.getList(this.saxExcelReader.read(file), Float::valueOf);
    }

    public List<Byte> readAsByte(InputStream inputStream) {
        return this.getList(this.saxExcelReader.read(inputStream), Byte::valueOf);
    }

    public List<Byte> readAsByte(File file) {
        return this.getList(this.saxExcelReader.read(file), Byte::valueOf);
    }

    private List<String> mapToString(List<Map> result) {
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return result.stream().map(map -> map.keySet().stream().filter(cell -> cell.getColNum() == this.columnNum).map(map::get).filter(Objects::nonNull).findFirst().orElse(null)).filter(v -> !this.ignoreBlankCell || v != null).collect(Collectors.toCollection(LinkedList::new));
    }

    private <T> List<T> getList(List<Map> result, Function<String, T> function) {
        List<String> strings = this.mapToString(result);
        return strings.stream().map(s -> s == null ? null : function.apply((String)s)).collect(Collectors.toCollection(LinkedList::new));
    }
}

