/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.DefaultStreamExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.usermodel.Workbook;

public class DefaultExcelBuilder<T>
implements Closeable {
    private static final String STYLE_COMMON_TD = "border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;";
    private static final String STYLE_TITLE = "font-weight:bold;font-size:14;text-align:center;vertical-align:middle;";
    private final DefaultStreamExcelBuilder<T> streamExcelBuilder;

    private DefaultExcelBuilder(DefaultStreamExcelBuilder<T> streamExcelBuilder) {
        streamExcelBuilder.widthStrategy(WidthStrategy.COMPUTE_AUTO_WIDTH);
        streamExcelBuilder.style("title->border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;font-weight:bold;font-size:14;text-align:center;vertical-align:middle;", "even->border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;", "odd->border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;background-color:#f6f8fa;");
        this.streamExcelBuilder = streamExcelBuilder;
    }

    public static <T> DefaultExcelBuilder<T> of(Class<T> dataType) {
        DefaultExcelBuilder<T> defaultExcelBuilder = new DefaultExcelBuilder<T>(DefaultStreamExcelBuilder.of(dataType));
        defaultExcelBuilder.streamExcelBuilder.workbookType(WorkbookType.XLSX);
        return defaultExcelBuilder;
    }

    public static <T> DefaultExcelBuilder<T> of(Class<T> dataType, Workbook workbook) {
        return new DefaultExcelBuilder<T>(DefaultStreamExcelBuilder.of(dataType, workbook));
    }

    public DefaultExcelBuilder<T> titles(List<String> titles) {
        this.streamExcelBuilder.titles(titles);
        return this;
    }

    public DefaultExcelBuilder<T> sheetName(String sheetName) {
        this.streamExcelBuilder.sheetName(sheetName);
        return this;
    }

    public DefaultExcelBuilder<T> fieldDisplayOrder(List<String> fieldDisplayOrder) {
        this.streamExcelBuilder.fieldDisplayOrder(fieldDisplayOrder);
        return this;
    }

    public DefaultExcelBuilder<T> workbookType(WorkbookType workbookType) {
        this.streamExcelBuilder.workbookType(workbookType);
        return this;
    }

    public DefaultExcelBuilder<T> noStyle() {
        this.streamExcelBuilder.noStyle();
        return this;
    }

    public DefaultExcelBuilder<T> widthStrategy(WidthStrategy widthStrategy) {
        this.streamExcelBuilder.widthStrategy(widthStrategy);
        return this;
    }

    @Deprecated
    public DefaultExcelBuilder<T> autoWidthStrategy(AutoWidthStrategy autoWidthStrategy) {
        this.streamExcelBuilder.autoWidthStrategy(autoWidthStrategy);
        return this;
    }

    public DefaultExcelBuilder<T> fixedTitles() {
        this.streamExcelBuilder.fixedTitles();
        return this;
    }

    public DefaultExcelBuilder<T> freezePane(FreezePane freezePane) {
        this.streamExcelBuilder.freezePane(freezePane);
        return this;
    }

    public DefaultExcelBuilder<T> widths(int ... widths) {
        this.streamExcelBuilder.widths(widths);
        return this;
    }

    public DefaultExcelBuilder<T> width(int columnIndex, int width) {
        this.streamExcelBuilder.width(columnIndex, width);
        return this;
    }

    public DefaultExcelBuilder<T> hideColumns(int ... columnIndexs) {
        this.streamExcelBuilder.hideColumns(columnIndexs);
        return this;
    }

    public DefaultExcelBuilder<T> groups(Class<?> ... groups) {
        this.streamExcelBuilder.groups((Class[])groups);
        return this;
    }

    @Deprecated
    public DefaultExcelBuilder<T> globalStyle(String ... styles) {
        return this.style(styles);
    }

    public DefaultExcelBuilder<T> style(String ... styles) {
        this.streamExcelBuilder.style(styles);
        return this;
    }

    public DefaultExcelBuilder<T> titleRowHeight(int titleRowHeight) {
        this.streamExcelBuilder.titleRowHeight(titleRowHeight);
        return this;
    }

    public DefaultExcelBuilder<T> rowHeight(int rowHeight) {
        this.streamExcelBuilder.rowHeight(rowHeight);
        return this;
    }

    public DefaultExcelBuilder<T> binding(Object ... applicationBeans) {
        this.streamExcelBuilder.binding(applicationBeans);
        return this;
    }

    public DefaultExcelBuilder<T> binding(Set<Object> applicationBeans) {
        this.streamExcelBuilder.binding(applicationBeans);
        return this;
    }

    public Workbook build(List<T> data) {
        try {
            this.streamExcelBuilder.start();
            this.streamExcelBuilder.append(data);
            return this.streamExcelBuilder.build();
        }
        catch (Exception e) {
            try {
                this.streamExcelBuilder.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.streamExcelBuilder != null) {
            this.streamExcelBuilder.close();
        }
    }
}

