/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.templatehandler;

import com.github.liaochong.myexcel.core.templatehandler.AbstractTemplateHandler;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.codec.CharEncoding;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;

public class BeetlTemplateHandler
extends AbstractTemplateHandler<GroupTemplate, Template> {
    private static final Map<String, GroupTemplate> CFG_MAP = new HashMap<String, GroupTemplate>();

    @Override
    protected void setTemplateEngine(String dirPath, Supplier<GroupTemplate> supplier, String fileName) {
        GroupTemplate groupTemplate = CFG_MAP.getOrDefault(dirPath, supplier.get());
        this.templateEngine = groupTemplate.getTemplate((Object)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GroupTemplate getTemplateEngineSupplier(String dirPath) {
        Class<BeetlTemplateHandler> clazz = BeetlTemplateHandler.class;
        synchronized (BeetlTemplateHandler.class) {
            Configuration cfg;
            GroupTemplate groupTemplate = CFG_MAP.get(dirPath);
            if (groupTemplate != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return groupTemplate;
            }
            Object resourceLoader = Objects.equals(dirPath, "classpath") ? new ClasspathResourceLoader() : new FileResourceLoader(dirPath, StandardCharsets.UTF_8.name());
            try {
                cfg = Configuration.defaultConfiguration();
            }
            catch (IOException e) {
                throw new ExcelBuildException("Set Beetl configuration failure", e);
            }
            cfg.setCharset(CharEncoding.UTF_8);
            groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
            CFG_MAP.put(dirPath, groupTemplate);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return groupTemplate;
        }
    }

    @Override
    protected <F> void render(Map<String, F> renderData, Writer out) throws Exception {
        ((Template)this.templateEngine).binding(renderData);
        ((Template)this.templateEngine).renderTo(out);
    }
}

