/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import com.github.marschall.memoryfilesystem.Root;
import java.net.URI;
import java.net.URISyntaxException;

class EmptyRoot
extends Root {
    static final String SLASH = "/";

    EmptyRoot(MemoryFileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    boolean isNamed() {
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        return other.equals(SLASH);
    }

    @Override
    public boolean endsWith(String other) {
        return other.equals(SLASH);
    }

    @Override
    boolean startsWith(AbstractPath other) {
        return this == other;
    }

    @Override
    boolean endsWith(AbstractPath other) {
        return this == other;
    }

    @Override
    String getKey() {
        return SLASH;
    }

    @Override
    public String toString() {
        return SLASH;
    }

    @Override
    public URI toUri() {
        try {
            return new URI("memory", this.getMemoryFileSystem().getKey() + ":///", null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)"could not create URI");
        }
    }

    @Override
    int compareTo(AbstractPath other) {
        return other == this ? 0 : -1;
    }
}

