/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis;

import com.github.microwww.redis.ChannelOutputStream;
import com.github.microwww.redis.ChannelSessionHandler;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.exception.Run;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.protocal.RedisOutputProtocol;
import com.github.microwww.redis.protocal.RequestSession;
import com.github.microwww.redis.protocal.RespV2;
import com.github.microwww.redis.protocal.jedis.JedisOutputStream;
import com.github.microwww.redis.util.Assert;
import com.github.microwww.redis.util.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.function.Consumer;

public class ChannelContext {
    private static final Logger log = LogFactory.getLogger(ChannelContext.class);
    private static final int DEF_CAPACITY = 8192;
    private static final String PUB_SUB_N_KEY = ChannelContext.class.getName() + ".channels.names";
    private static final String PUB_SUB_P_KEY = ChannelContext.class.getName() + ".channels.pattens";
    private final String remoteHost;
    private final CloseObservable listeners = new CloseObservable();
    private final SocketChannel channel;
    private final RequestSession sessions;
    private ByteBuffer buffer = ChannelContext.newByteBuffer();
    private final Subscribe subscribe;
    private final Subscribe pattenSubscribe;
    private RedisOutputProtocol protocol;
    private ChannelSessionHandler channelHandler;

    public ChannelContext(SocketChannel channel) {
        this.channel = channel;
        this.sessions = new RequestSession(channel);
        JedisOutputStream outputStream = new JedisOutputStream(new ChannelOutputStream(this.channel){

            @Override
            public void close() {
                throw new UnsupportedOperationException("Not invoke it!, By `closeChannel`");
            }
        });
        this.protocol = new RespV2(outputStream);
        this.subscribe = new Subscribe(PUB_SUB_N_KEY);
        this.pattenSubscribe = new Subscribe(PUB_SUB_P_KEY);
        this.remoteHost = StringUtil.remoteHost(channel);
    }

    ChannelSessionHandler getChannelHandler() {
        return this.channelHandler;
    }

    void setChannelHandler(ChannelSessionHandler channelHandler) {
        this.channelHandler = channelHandler;
    }

    public ChannelContext assertChannel(SelectableChannel channel) {
        Assert.isTrue(this.channel == channel, "Channel not equal");
        return this;
    }

    public void closeChannel() throws IOException {
        try {
            this.protocol.getOut().flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.close();
            this.channel.close();
        }
    }

    public RequestSession getSessions() {
        return this.sessions;
    }

    public ByteBuffer readChannel() throws IOException {
        int read = this.channel.read(this.buffer);
        if (read < 0) {
            throw new IOException("EOF");
        }
        this.buffer.flip();
        return this.buffer.asReadOnlyBuffer();
    }

    void readOver(ByteBuffer residue) throws IOException {
        if (residue.remaining() > 0) {
            if (residue.remaining() >= this.buffer.capacity()) {
                this.buffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
            }
            this.buffer.clear();
            this.buffer.put(residue);
        } else if (this.buffer.capacity() == 8192) {
            this.buffer.clear();
        } else {
            this.buffer = ChannelContext.newByteBuffer();
        }
    }

    private static ByteBuffer newByteBuffer() {
        return ByteBuffer.allocate(1024);
    }

    public RedisOutputProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(RedisOutputProtocol protocol) {
        this.protocol = protocol;
    }

    public Subscribe getSubscribe() {
        return this.subscribe;
    }

    public Subscribe getPattenSubscribe() {
        return this.pattenSubscribe;
    }

    public CloseListener addCloseListener(Consumer<ChannelContext> notify) {
        return this.addCloseListener0(() -> notify.accept(this));
    }

    public CloseListener addCloseListener0(Runnable notify) {
        CloseListener os = new CloseListener(notify);
        this.listeners.addObserver(os);
        log.debug("Add close listener, now {}", this.listeners.countObservers());
        return os;
    }

    public void removeCloseListener(CloseListener listener) {
        log.debug("Remove close listener, now {}", this.listeners.countObservers());
        this.listeners.deleteObserver(listener);
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    protected void close() {
        log.warn("CLOSE {}", this.getRemoteHost());
        Run.ignoreException(log, this.listeners::doClose);
        Run.ignoreException(log, () -> this.channelHandler.close(this));
        Run.ignoreException(log, () -> {
            this.subscribe.removeSubscribe();
            Map subscribes = this.subscribe.subscribes();
            if (subscribes != null) {
                subscribes.clear();
            }
        });
        this.sessions.close();
    }

    public class Subscribe {
        private final String key;

        public Subscribe(String key) {
            this.key = key;
            ChannelContext.this.sessions.put(key, new LinkedHashMap());
        }

        public <T extends Observer> Map<Bytes, T> subscribeChannels() {
            return Collections.unmodifiableMap(this.subscribes());
        }

        private <T extends Observer> Map<Bytes, T> subscribes() {
            return (Map)ChannelContext.this.sessions.get(this.key);
        }

        public <T extends Observer> void addSubscribe(Bytes channel, T v) {
            this.subscribes().put(channel, v);
        }

        public <T extends Observer> Optional<T> getSubscribe(Bytes channel) {
            return Optional.ofNullable((Observer)this.subscribes().get(channel));
        }

        public <T extends Observer> Optional<T> removeSubscribe(Bytes channel) {
            return Optional.ofNullable((Observer)this.subscribes().remove(channel));
        }

        public void removeSubscribe() {
            this.subscribes().clear();
        }
    }

    public class CloseListener
    implements Observer {
        private final Runnable notify;

        public CloseListener(Runnable notify) {
            this.notify = notify;
        }

        @Override
        public void update(Observable o, Object arg) {
            Run.ignoreException(log, () -> this.notify.run());
        }
    }

    public class CloseObservable
    extends Observable {
        public void doClose() {
            this.setChanged();
            log.debug("Notify channel-context close listener - {}", ChannelContext.this.listeners.countObservers());
            this.notifyObservers(ChannelContext.this);
        }
    }
}

