/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.database.DataLock;
import com.github.microwww.redis.database.HashKey;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HashData
extends AbstractValueData<Map<HashKey, Bytes>>
implements DataLock {
    private final Map<HashKey, Bytes> origin;

    public HashData() {
        this(-1L);
    }

    public HashData(long exp) {
        this(new ConcurrentHashMap<HashKey, Bytes>(), exp);
    }

    public HashData(Map<HashKey, Bytes> origin, long exp) {
        this.origin = origin;
        this.data = Collections.unmodifiableMap(origin);
        this.expire = exp;
    }

    @Override
    public String getType() {
        return "hash";
    }

    public synchronized Bytes remove(HashKey key) {
        if (this.origin.containsKey(key)) {
            this.version.incrementAndGet();
            return this.origin.remove(key);
        }
        return null;
    }

    public synchronized Bytes incrBy(HashKey key, int inc) {
        Bytes bt = this.origin.get(key);
        BigInteger bi = bt == null ? BigInteger.ZERO : new BigInteger(bt.toString());
        bi = bi.add(BigInteger.valueOf(inc));
        Bytes bytes = new Bytes(bi.toString().getBytes());
        this.origin.put(key, bytes);
        this.version.incrementAndGet();
        return bytes;
    }

    public synchronized Bytes incrByFloat(HashKey key, BigDecimal inc) {
        Bytes bt = this.origin.get(key);
        BigDecimal bi = bt == null ? BigDecimal.ZERO : new BigDecimal(bt.toString());
        bi = bi.add(inc);
        Bytes bytes = new Bytes(bi.toPlainString().getBytes());
        this.origin.put(key, bytes);
        this.version.incrementAndGet();
        return bytes;
    }

    public synchronized int multiSet(RequestParams[] kvs, int offset) {
        for (int i = offset; i < kvs.length; i += 2) {
            this.origin.put(kvs[i].byteArray2hashKey(), kvs[i + 1].toBytes());
        }
        this.version.incrementAndGet();
        return kvs.length - offset / 2;
    }

    public synchronized Bytes put(HashKey key, byte[] bytes) {
        this.version.incrementAndGet();
        return this.origin.put(key, new Bytes(bytes));
    }

    public synchronized Bytes putIfAbsent(HashKey key, byte[] bytes) {
        Bytes val = this.origin.putIfAbsent(key, new Bytes(bytes));
        if (val == null) {
            this.version.incrementAndGet();
        }
        return val;
    }
}

