/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.DataLock;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.Member;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.protocal.operation.SortedSetOperation;
import com.github.microwww.redis.util.Assert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SortedSetData
extends AbstractValueData<NavigableSet<Member>>
implements DataLock {
    private final ConcurrentSkipListSet<Member> origin;
    private final HashMap<HashKey, Member> unique = new HashMap();

    public SortedSetData() {
        this(-1);
    }

    public SortedSetData(int exp) {
        this.origin = new ConcurrentSkipListSet<Member>(Member.COMPARATOR);
        this.data = Collections.unmodifiableNavigableSet(this.origin);
        this.expire = exp;
    }

    public SortedSet<Member> getSubSetData(boolean desc, SortedSetOperation.Interval start, SortedSetOperation.Interval stop) {
        if (desc) {
            if (start.val.compareTo(stop.val) < 0) {
                return Collections.emptySortedSet();
            }
            return this.origin.descendingSet().subSet(Member.MAX(start.val), Member.MIN(stop.val));
        }
        if (start.val.compareTo(stop.val) > 0) {
            return Collections.emptySortedSet();
        }
        return ((NavigableSet)this.data).subSet(Member.MIN(start.val), Member.MAX(stop.val));
    }

    @Override
    public String getType() {
        return "zset";
    }

    public synchronized int addOrReplace(Member ... member) {
        int count = 0;
        for (Member m : member) {
            Member og = this.addElement(m);
            if (og != null) continue;
            ++count;
        }
        return count;
    }

    private synchronized Member addElement(Member member) {
        Assert.isNotNull(member.getMember(), "member.byte[] not null");
        Member put = this.unique.put(member.getKey(), member);
        if (put != null) {
            this.origin.remove(put);
        }
        this.version.incrementAndGet();
        this.origin.add(member);
        return put;
    }

    public synchronized Member inc(byte[] member, BigDecimal inc) {
        Member mem = this.unique.get(new HashKey(member));
        mem = mem != null ? new Member(member, inc.add(mem.getScore())) : new Member(member, inc);
        this.addElement(mem);
        return mem;
    }

    public synchronized List<Member> range(int from, int includeTo) {
        Iterator<Member> its = this.origin.iterator();
        return this.range(its, from, includeTo);
    }

    private int dynIndex(int i) {
        int max = this.origin.size();
        if (max == 0) {
            return 0;
        }
        while (i < 0) {
            i += max;
        }
        return i;
    }

    public synchronized List<Member> range(Iterator<Member> its, int from, int includeTo) {
        if ((from = this.dynIndex(from)) > (includeTo = this.dynIndex(includeTo))) {
            return Collections.emptyList();
        }
        if (from >= this.origin.size()) {
            return Collections.emptyList();
        }
        ArrayList<Member> list = new ArrayList<Member>();
        int i = 0;
        while (its.hasNext()) {
            Member next = its.next();
            if (i > includeTo) break;
            if (i >= from) {
                list.add(next);
            }
            ++i;
        }
        return list;
    }

    public synchronized int rank(Iterator<Member> its, byte[] member) {
        int i = 0;
        while (its.hasNext()) {
            Member next = its.next();
            if (Arrays.equals(next.getMember(), member)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized int removeAll(List<HashKey> list) {
        int count = 0;
        for (HashKey m : list) {
            Member member = this.unique.remove(m);
            if (member == null) continue;
            this.origin.remove(member);
            ++count;
        }
        if (count > 0) {
            this.version.incrementAndGet();
        }
        return count;
    }

    public synchronized int remRangeByRank(int start, int includeStop) {
        Iterator<Member> it = this.origin.iterator();
        if (this.origin.isEmpty()) {
            return 0;
        }
        while (start < 0) {
            start += this.origin.size();
        }
        while (includeStop < 0) {
            includeStop += this.origin.size();
        }
        if (start > includeStop) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (it.hasNext()) {
            it.next();
            if (i >= start) {
                if (i > includeStop) break;
                it.remove();
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            this.version.incrementAndGet();
        }
        return count;
    }

    public synchronized int remRangeByScore(SortedSetOperation.Interval min, SortedSetOperation.Interval max) {
        List<HashKey> rms = this.origin.subSet((Object)Member.MIN(min.val), (Object)Member.MAX(max.val)).stream().filter(e -> min.filterEqual((Member)e)).filter(e -> max.filterEqual((Member)e)).map(Member::getKey).collect(Collectors.toList());
        this.removeAll(rms);
        return rms.size();
    }

    public synchronized List<Member> revRange(int from, int to) {
        Iterator<Member> its = this.origin.descendingSet().iterator();
        return this.range(its, from, to);
    }

    public int revRank(byte[] member) {
        return this.rank(this.origin.descendingSet().iterator(), member);
    }

    public Optional<Member> member(HashKey key) {
        return Optional.ofNullable(this.unique.get(key));
    }

    public synchronized int unionStore(RedisDatabase rd, SortedSetOperation.UnionStore us) {
        SortedSetData[] ssd = (SortedSetData[])Arrays.stream(us.getHashKeys()).map(e -> rd.get((HashKey)e)).filter(Optional::isPresent).map(Optional::get).toArray(SortedSetData[]::new);
        int[] wt = us.getWeights();
        int size = this.recursiveLock(ssd, 0, () -> {
            HashMap<HashKey, BigDecimal> map = new HashMap<HashKey, BigDecimal>();
            for (int i = 0; i < ssd.length; ++i) {
                SortedSetData s = ssd[i];
                BigDecimal w = BigDecimal.valueOf(wt[i]);
                s.origin.forEach(e -> {
                    BigDecimal og = (BigDecimal)map.get(e.getKey());
                    og = (BigDecimal)us.getType().apply(og, e.getScore().multiply(w));
                    map.put(e.getKey(), og);
                });
            }
            map.forEach((k, v) -> this.addElement(new Member(k.getBytes(), (BigDecimal)v)));
            return this.origin.size();
        });
        return size;
    }

    public synchronized <T> T recursiveLock(SortedSetData[] ssd, int index, Supplier<T> fun) {
        if (index < ssd.length) {
            return (T)ssd[index].sync(() -> this.recursiveLock(ssd, index + 1, fun));
        }
        return fun.get();
    }

    public synchronized int interStore(RedisDatabase rd, SortedSetOperation.UnionStore us) {
        SortedSetData[] ssd = (SortedSetData[])Arrays.stream(us.getHashKeys()).map(e -> rd.get((HashKey)e)).filter(Optional::isPresent).map(Optional::get).toArray(SortedSetData[]::new);
        if (ssd.length == 0) {
            return 0;
        }
        int[] wt = us.getWeights();
        Map<HashKey, List<Member>> map = ((NavigableSet)ssd[0].getData()).stream().collect(Collectors.groupingBy(Member::getKey));
        int size = this.recursiveLock(ssd, 0, () -> {
            for (int i = 1; i < ssd.length; ++i) {
                SortedSetData s = ssd[i];
                ((NavigableSet)s.getData()).forEach(e -> {
                    List m = (List)map.get(e.getKey());
                    if (m != null) {
                        m.add(e);
                    }
                });
            }
            map.forEach((k, vs) -> {
                if (vs.size() != wt.length) {
                    return;
                }
                BigDecimal val = null;
                for (int i = 0; i < vs.size(); ++i) {
                    BigDecimal score = ((Member)vs.get(i)).getScore().multiply(BigDecimal.valueOf(wt[i]));
                    val = (BigDecimal)us.getType().apply(val, score);
                }
                this.addElement(new Member(k.getBytes(), val));
            });
            return this.origin.size();
        });
        return size;
    }
}

