/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.AbstractValueData;
import com.github.microwww.redis.database.BitArray;
import com.github.microwww.redis.database.ByteData;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.protocal.operation.StringOperation;
import com.github.microwww.redis.util.Assert;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;

public abstract class StringData {
    public static final byte[] ZERO = new byte[0];

    public static ByteData append(RedisDatabase db, HashKey key, byte[] bytes) {
        return db.sync(() -> {
            ByteData v = db.getOrCreate(key, () -> new ByteData(new byte[0], -1L));
            byte[] origin = (byte[])v.getData();
            byte[] target = new byte[origin.length + bytes.length];
            System.arraycopy(origin, 0, target, 0, origin.length);
            System.arraycopy(bytes, 0, target, origin.length, bytes.length);
            v.setData(target);
            return v;
        });
    }

    public static int bitCount(RedisDatabase db, HashKey key, int start, int end) {
        return db.get(key, ByteData.class).map(e -> new BitArray((byte[])e.getData()).count(true, start, end)).orElse(0);
    }

    public static ByteData bitOperation(RedisDatabase db, ByteOpt opt, HashKey dest, HashKey[] key) {
        ByteData init = new ByteData(new byte[0], -1L);
        return db.sync(() -> {
            ByteData from = db.get(key[0], ByteData.class).orElse(init);
            byte[] res = (byte[])from.getData();
            for (int i = 1; i < key.length; ++i) {
                ByteData dta = db.get(key[i], ByteData.class).orElse(init);
                res = StringData.bitOperation(res, (byte[])dta.getData(), opt);
            }
            if (opt.equals((Object)ByteOpt.NOT)) {
                res = StringData.bitOperation(res, new byte[0], opt);
            }
            ByteData target = new ByteData(res, -1L);
            db.put(dest, target);
            return target;
        });
    }

    public static byte[] bitOperation(byte[] data, byte[] bytes, ByteOpt opt) {
        int max = Math.max(data.length, bytes.length);
        byte[] mx = new byte[max];
        for (int i = 0; i < max; ++i) {
            byte f = 0;
            if (i < data.length) {
                f = data[i];
            }
            byte t = 0;
            if (i < bytes.length) {
                t = bytes[i];
            }
            mx[i] = opt.apply(f, t);
        }
        return mx;
    }

    public static Optional<ByteData> getSet(RedisDatabase db, HashKey key, byte[] value) {
        return db.sync(() -> {
            Optional<ByteData> val = db.get(key, ByteData.class);
            db.put(key, new ByteData(value, -1L));
            return val;
        });
    }

    public static ByteData setRange(RedisDatabase database, HashKey key, int off, byte[] val) {
        Assert.isTrue(off >= 0, "offset >= 0");
        Assert.isTrue(Integer.MAX_VALUE - off > val.length, "Over max int !");
        return database.sync(() -> {
            Optional<ByteData> opt = database.get(key, ByteData.class);
            if (opt.isPresent()) {
                byte[] org = (byte[])opt.get().getData();
                if (org.length < off + val.length) {
                    byte[] bts = new byte[off + val.length];
                    System.arraycopy(org, 0, bts, 0, org.length);
                    opt.get().setData(bts);
                }
            } else {
                opt = Optional.of(new ByteData(new byte[off + val.length], -1L));
                database.put(key, opt.get());
            }
            System.arraycopy(val, 0, opt.get().getData(), off, val.length);
            return opt.get();
        });
    }

    public static int increase(RedisDatabase db, HashKey key, int add) {
        return db.sync(() -> {
            ByteData or = StringData.getOrInitZero(db, key);
            int num = add + Integer.parseInt(new String((byte[])or.getData()));
            or.setData((num + "").getBytes());
            return num;
        });
    }

    private static ByteData getOrInitZero(RedisDatabase db, HashKey key) {
        return db.getOrCreate(key, () -> new ByteData(new byte[]{48}, -1L));
    }

    public static int getBIT(RedisDatabase db, HashKey key, int offset) {
        Optional<ByteData> opt = db.get(key, ByteData.class);
        return opt.map(e -> {
            BitArray b = new BitArray((byte[])e.getData());
            if (b.bitLength() > offset) {
                return b.get(offset) ? 1 : 0;
            }
            return 0;
        }).orElse(0);
    }

    public static byte[] subString(RedisDatabase db, HashKey key, int from, int includeTo) {
        Optional<ByteData> opt = db.get(key, ByteData.class);
        if (opt.isPresent()) {
            int end;
            ByteData e = opt.get();
            int start = from;
            int len = ((byte[])e.getData()).length;
            if (start < 0) {
                start += len;
            }
            if ((end = includeTo) < 0) {
                end += len;
            }
            if (start > end) {
                return ZERO;
            }
            if (start >= len) {
                return ZERO;
            }
            return Arrays.copyOfRange((byte[])e.getData(), start, Math.min(len, end + 1));
        }
        return ZERO;
    }

    public static BigDecimal increase(RedisDatabase db, HashKey key, double add) {
        return db.sync(() -> {
            ByteData or = StringData.getOrInitZero(db, key);
            BigDecimal num = new BigDecimal(new String((byte[])or.getData())).add(BigDecimal.valueOf(add));
            or.setData(num.toPlainString().getBytes());
            return num;
        });
    }

    public static int multiSet(RedisDatabase database, RequestParams[] args, boolean overWrite) {
        Assert.isTrue(args.length % 2 == 0, "2x");
        return database.sync(() -> {
            HashKey key;
            int i;
            if (!overWrite) {
                for (i = 0; i < args.length; i += 2) {
                    key = args[i].byteArray2hashKey();
                    Optional<AbstractValueData<?>> opt = database.get(key);
                    if (!opt.isPresent()) continue;
                    return 0;
                }
            }
            for (i = 0; i < args.length; i += 2) {
                key = args[i].byteArray2hashKey();
                byte[] val = args[i + 1].getByteArray();
                database.put(key, val);
            }
            return args.length / 2;
        });
    }

    public static boolean set(RedisDatabase db, StringOperation.Params spm, HashKey key, ByteData val) {
        return db.sync(() -> {
            Optional<AbstractValueData<?>> opt = db.get(key);
            if (opt.isPresent()) {
                if (spm.isXx()) {
                    db.put(key, val);
                    return true;
                }
            } else if (spm.isNx()) {
                db.put(key, val);
                return true;
            }
            if (!spm.isNx() && !spm.isXx()) {
                db.put(key, val);
                return true;
            }
            return false;
        });
    }

    public static boolean setBit(RedisDatabase db, HashKey key, int offset, boolean one) {
        int size = (offset >>> 3) + 1;
        ByteData str = db.getOrCreate(key, () -> new ByteData(new byte[size], -1L));
        byte[] od = (byte[])str.getData();
        if (od.length < size) {
            byte[] ov = new byte[size];
            System.arraycopy(od, 0, ov, 0, od.length);
            str.setData(ov);
        }
        BitArray st = new BitArray((byte[])str.getData());
        boolean origin = st.get(offset);
        if (one) {
            st.set(offset);
        } else {
            st.clean(offset);
        }
        str.setData(st.toArray());
        return origin;
    }

    public static enum ByteOpt {
        AND{

            @Override
            public byte apply(byte a, byte b) {
                return (byte)(a & b);
            }
        }
        ,
        OR{

            @Override
            public byte apply(byte a, byte b) {
                return (byte)(a | b);
            }
        }
        ,
        XOR{

            @Override
            public byte apply(byte a, byte b) {
                return (byte)(a ^ b);
            }
        }
        ,
        NOT{

            @Override
            public byte apply(byte o, byte ignore) {
                return ~o;
            }
        };


        public abstract byte apply(byte var1, byte var2);
    }
}

