/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.ChannelContext;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.Schema;
import com.github.microwww.redis.protocal.RedisOutputProtocol;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.jedis.Protocol;
import com.github.microwww.redis.protocal.operation.TransactionOperation;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Transaction
implements Closeable {
    public static final String SESSION_NAME = "session." + Transaction.class.getName();
    private final List<RedisRequest> requests;
    private final Map<HashKey, TransactionOperation.DV> watches = new HashMap<HashKey, TransactionOperation.DV>();
    private boolean enable = false;

    public Transaction() {
        this.requests = new ArrayList<RedisRequest>();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void start() {
        this.enable = true;
    }

    public void exec(RedisRequest request) throws IOException {
        Schema schema = request.getServer().getSchema();
        String cmd = request.getCommand();
        if ("multi".equalsIgnoreCase(cmd)) {
            this.requests.add(request);
            request.getOutputProtocol().writer(Protocol.Keyword.OK.raw);
        } else if ("exec".equalsIgnoreCase(cmd)) {
            schema.run(request);
        } else if ("discard".equalsIgnoreCase(cmd)) {
            schema.run(request);
        } else if ("watch".equalsIgnoreCase(cmd)) {
            request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, "WATCH inside MULTI is not allowed");
        } else {
            this.requests.add(request);
            request.getOutputProtocol().writer(Protocol.Keyword.QUEUED.raw);
        }
    }

    public static Transaction getTransaction(RedisRequest request) {
        Transaction tx = (Transaction)request.getContext().getSessions().computeIfAbsent(SESSION_NAME, k -> new Transaction());
        return tx;
    }

    public static Optional<Transaction> ifTransaction(ChannelContext context) {
        Object tx = context.getSessions().get(SESSION_NAME);
        return Optional.ofNullable((Transaction)tx);
    }

    public List<RedisRequest> getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    public Map<HashKey, TransactionOperation.DV> getWatches() {
        return Collections.unmodifiableMap(this.watches);
    }

    public void putWatch(HashKey hash, TransactionOperation.DV value) {
        this.watches.put(hash, value);
    }

    public void clearWatches() {
        this.watches.clear();
    }

    @Override
    public void close() {
        this.enable = false;
        try {
            this.requests.clear();
        }
        finally {
            this.watches.clear();
        }
    }
}

