/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.logger;

import com.github.microwww.redis.logger.JavaLogger;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.logger.Slf4jLogger;

public class LogFactory {
    private static LoggerImpl imp;

    public static Logger getLogger(String name) {
        return imp.create(name);
    }

    public static Logger getLogger(Class clazz) {
        return imp.create(clazz.getName());
    }

    public static Throwable getThrowable(Object ... params) {
        for (int i = params.length - 1; i >= 0; --i) {
            Object p = params[i];
            if (!(p instanceof Throwable)) continue;
            return (Throwable)p;
        }
        return null;
    }

    static {
        for (LoggerImpl value : LoggerImpl.values()) {
            if (!value.isSupport()) continue;
            imp = value;
            break;
        }
    }

    public static enum LoggerImpl {
        SLF4J{

            @Override
            public Logger create(String name) {
                return new Slf4jLogger(name);
            }

            @Override
            public boolean isSupport() {
                try {
                    Class.forName("org.slf4j.LoggerFactory");
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }
        }
        ,
        JAVA{

            @Override
            public Logger create(String name) {
                return new JavaLogger(name);
            }

            @Override
            public boolean isSupport() {
                return true;
            }
        };


        public abstract Logger create(String var1);

        public abstract boolean isSupport();
    }
}

