/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.operation;

import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.database.HashData;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.protocal.AbstractOperation;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.ScanIterator;
import com.github.microwww.redis.protocal.jedis.Protocol;
import com.github.microwww.redis.util.Assert;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class HashOperation
extends AbstractOperation {
    public void hdel(RedisRequest request) throws IOException {
        request.expectArgumentsCountBigger(1);
        Optional<HashData> data = this.getHashData(request);
        int count = 0;
        if (data.isPresent()) {
            HashData e = data.get();
            RequestParams[] args = request.getParams();
            for (int i = 1; i < args.length; ++i) {
                HashKey hk = args[i].byteArray2hashKey();
                Bytes remove = e.remove(hk);
                if (remove == null) continue;
                ++count;
            }
        }
        request.getOutputProtocol().writer(count);
    }

    public void hexists(RedisRequest request) throws IOException {
        boolean exist;
        request.expectArgumentsCount(2);
        RequestParams[] args = request.getParams();
        HashKey hk = args[1].byteArray2hashKey();
        Optional<Map<HashKey, Bytes>> opt = this.getHashMap(request);
        if (opt.isPresent() && (exist = opt.get().containsKey(hk))) {
            request.getOutputProtocol().writer(1);
            return;
        }
        request.getOutputProtocol().writer(0);
    }

    public void hget(RedisRequest request) throws IOException {
        Bytes dh;
        request.expectArgumentsCount(2);
        RequestParams[] args = request.getParams();
        HashKey hk = args[1].byteArray2hashKey();
        Optional<HashData> opt = this.getHashData(request);
        if (opt.isPresent() && (dh = (Bytes)((Map)opt.get().getData()).get(hk)) != null) {
            request.getOutputProtocol().writer(dh);
            return;
        }
        request.getOutputProtocol().writerNull();
    }

    public void hgetall(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<Map<HashKey, Bytes>> opt = this.getHashMap(request);
        if (opt.isPresent()) {
            ArrayList list = new ArrayList();
            opt.get().forEach((k, v) -> {
                list.add(k.getBytes());
                list.add(v.getBytes());
            });
            request.getOutputProtocol().writerMulti((byte[][])list.toArray((T[])new byte[list.size()][]));
        } else {
            request.getOutputProtocol().writerMulti(new byte[0][]);
        }
    }

    public void hincrby(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        HashKey hk = request.getParams()[1].byteArray2hashKey();
        int inc = request.getParams()[2].byteArray2int();
        HashData oc = this.getOrCreate(request);
        Bytes bytes = oc.incrBy(hk, inc);
        request.getOutputProtocol().writer(bytes.toLong());
    }

    public void hincrbyfloat(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        HashKey key = request.getParams()[0].byteArray2hashKey();
        HashKey hk = request.getParams()[1].byteArray2hashKey();
        BigDecimal inc = request.getParams()[2].byteArray2decimal();
        HashData oc = this.getOrCreate(request);
        Bytes bytes = oc.incrByFloat(hk, inc);
        request.getOutputProtocol().writer(bytes);
    }

    public void hkeys(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<Map<HashKey, Bytes>> map = this.getHashMap(request);
        if (map.isPresent()) {
            byte[][] ks = (byte[][])map.get().keySet().stream().map(Bytes::getBytes).toArray(x$0 -> new byte[x$0][]);
            request.getOutputProtocol().writerMulti(ks);
        } else {
            request.getOutputProtocol().writerMulti(new byte[0][]);
        }
    }

    public void hlen(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<Map<HashKey, Bytes>> map = this.getHashMap(request);
        int count = map.map(e -> e.size()).orElse(0);
        request.getOutputProtocol().writer(count);
    }

    public void hmget(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(2);
        RequestParams[] args = request.getParams();
        Optional<Map<HashKey, Bytes>> opt = this.getHashMap(request);
        byte[][] bytes = (byte[][])Arrays.stream(args, 1, args.length).map(e -> e.byteArray2hashKey()).map(e -> opt.flatMap(e1 -> Optional.ofNullable(e1.get(e))).map(Bytes::getBytes).orElse(null)).toArray(x$0 -> new byte[x$0][]);
        request.getOutputProtocol().writerMulti(bytes);
    }

    public void hmset(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(3);
        HashData oc = this.getOrCreate(request);
        RequestParams[] args = request.getParams();
        Assert.isTrue(args.length % 2 == 1, "k, k-v, k-v, k-v, ...");
        oc.multiSet(args, 1);
        request.getOutputProtocol().writer(Protocol.Keyword.OK.name());
    }

    public void hset(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        RequestParams[] args = request.getParams();
        HashData data = this.getOrCreate(request);
        byte[] hk = args[1].getByteArray();
        byte[] val = args[2].getByteArray();
        Bytes origin = data.put(new HashKey(hk), val);
        request.getOutputProtocol().writer(origin == null ? 1 : 0);
    }

    public void hsetnx(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        RequestParams[] args = request.getParams();
        HashData data = this.getOrCreate(request);
        byte[] hk = args[1].getByteArray();
        byte[] val = args[2].getByteArray();
        Bytes origin = data.putIfAbsent(new HashKey(hk), val);
        request.getOutputProtocol().writer(origin == null ? 1 : 0);
    }

    public void hvals(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<Map<HashKey, Bytes>> map = this.getHashMap(request);
        if (map.isPresent()) {
            byte[][] ks = (byte[][])map.get().values().stream().map(Bytes::getBytes).toArray(x$0 -> new byte[x$0][]);
            request.getOutputProtocol().writerMulti(ks);
        } else {
            request.getOutputProtocol().writerMulti(new byte[0][]);
        }
    }

    public void hscan(RedisRequest request) throws IOException {
        HashData data = this.getHashData(request).orElse(new HashData());
        Set hk = ((Map)data.getData()).keySet();
        Iterator iterator = hk.iterator();
        new ScanIterator(request, 1).skip(iterator).continueWrite(iterator, e -> e.getBytes(), e -> ((Bytes)((Map)data.getData()).get(e)).getBytes());
    }

    private Optional<Map<HashKey, Bytes>> getHashMap(RedisRequest request) {
        return this.getHashData(request).map(e -> (Map)e.getData());
    }

    private Optional<HashData> getHashData(RedisRequest request) {
        RequestParams[] args = request.getParams();
        HashKey key = args[0].byteArray2hashKey();
        return request.getDatabase().get(key, HashData.class);
    }

    private HashData getOrCreate(RedisRequest request) {
        RequestParams[] args = request.getParams();
        HashKey key = args[0].byteArray2hashKey();
        return request.getDatabase().getOrCreate(key, () -> new HashData());
    }
}

