/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.operation;

import com.github.microwww.redis.RequestParams;
import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.database.HashKey;
import com.github.microwww.redis.database.ListData;
import com.github.microwww.redis.database.RedisDatabase;
import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import com.github.microwww.redis.protocal.AbstractOperation;
import com.github.microwww.redis.protocal.RedisOutputProtocol;
import com.github.microwww.redis.protocal.RedisRequest;
import com.github.microwww.redis.protocal.jedis.Protocol;
import com.github.microwww.redis.util.IoConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;

public class ListOperation
extends AbstractOperation {
    private static final long MAX_WAIT_SECONDS = 31536000L;
    private static final Logger log = LogFactory.getLogger(ListOperation.class);

    public void blpop(RedisRequest request) throws IOException {
        this.blockPOP(request, ListData::leftPop);
    }

    public void brpop(RedisRequest request) throws IOException {
        this.blockPOP(request, ListData::rightPop);
    }

    public void pop_close(AddListener listener) throws IOException {
        RedisRequest request = listener.request;
        request.getOutputProtocol().writerMulti(new byte[0][]);
        request.getOutputProtocol().flush();
    }

    private void blockPOP(RedisRequest request, Function<ListData, Optional<Bytes>> pop) throws IOException {
        RequestParams[] args = request.getParams();
        long timeoutSeconds = args[args.length - 1].byteArray2long();
        this.blockPOP(request, timeoutSeconds, pop);
    }

    private AddListener blockPOP(RedisRequest request, final long timeoutSeconds, final Function<ListData, Optional<Bytes>> pop) throws IOException {
        request.expectArgumentsCountGE(2);
        RequestParams[] args = request.getParams();
        AddListener listener = new AddListener(request, timeoutSeconds){

            @Override
            public void changeRunning(long time) {
                try {
                    ListOperation.this.blockPOP(this.request, timeoutSeconds, pop);
                    this.request.getOutputProtocol().flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (int i = 0; i < args.length - 1; ++i) {
            RequestParams param = request.getParams()[i];
            ListData list = this.getOrCreateList(request, i);
            listener.subscribe(list);
            Optional<Bytes> bytes = pop.apply(list);
            if (!bytes.isPresent()) continue;
            listener.clear();
            request.getOutputProtocol().writerMulti(param.getByteArray(), bytes.get().getBytes());
            return listener;
        }
        if (timeoutSeconds > 0L) {
            listener.timerSchedule(this::pop_close);
        }
        return listener;
    }

    public void brpoplpush(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        long timeoutSeconds = request.getParams()[2].byteArray2long();
        this.brpoplpush(request, timeoutSeconds);
    }

    private void brpoplpush(RedisRequest request, long timeoutSeconds) throws IOException {
        AddListener listener = new AddListener(request, timeoutSeconds){

            @Override
            public void changeRunning(long remainTime) {
                try {
                    ListOperation.this.brpoplpush(this.request, remainTime);
                    this.request.getOutputProtocol().flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ListData list = this.getOrCreateList(request, 0);
        listener.subscribe(list);
        Optional<Bytes> bytes = list.rightPop();
        if (bytes.isPresent()) {
            listener.clear();
            ListData target = this.getOrCreateList(request, 1);
            byte[] val = bytes.get().getBytes();
            target.leftAdd(new byte[][]{val});
            request.getOutputProtocol().writer(val);
            return;
        }
        if (timeoutSeconds > 0L) {
            listener.timerSchedule(this::brpoplpush_close);
        }
    }

    public void brpoplpush_close(AddListener listener) {
        RedisRequest request = listener.request;
        try {
            request.getOutputProtocol().writer(new byte[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void lindex(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        RequestParams[] args = request.getParams();
        Optional<ListData> opt = this.getList(request);
        if (opt.isPresent()) {
            int index = Integer.parseInt(args[1].getByteArray2string());
            byte[][] bt = opt.get().range(index, index);
            request.getOutputProtocol().writer(bt.length == 0 ? null : bt[0]);
        } else {
            request.getOutputProtocol().writerNull();
        }
    }

    public void linsert(RedisRequest request) throws IOException {
        request.expectArgumentsCount(4);
        RequestParams[] args = request.getParams();
        Optional<ListData> opt = this.getList(request);
        if (opt.isPresent()) {
            boolean before = false;
            String key = args[1].getByteArray2string();
            if (key.equalsIgnoreCase("before")) {
                before = true;
            }
            byte[] pivot = args[2].getByteArray();
            byte[] val = args[3].getByteArray();
            boolean insert = opt.get().findAndOffsetInsert(pivot, before ? 0 : 1, val);
            int len = -1;
            if (insert) {
                len = ((List)opt.get().getData()).size();
            }
            request.getOutputProtocol().writer(len);
        } else {
            request.getOutputProtocol().writer(0);
        }
    }

    public void llen(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<ListData> opt = this.getList(request);
        int size = opt.map(e -> ((List)e.getData()).size()).orElse(0);
        request.getOutputProtocol().writer(size);
    }

    public void lpop(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<ListData> opt = this.getList(request);
        Bytes data = null;
        if (opt.isPresent()) {
            Optional<Bytes> bytes = opt.get().leftPop();
            data = bytes.orElse(null);
        }
        request.getOutputProtocol().writer(data);
    }

    public void lpush(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(2);
        ListData data = this.getOrCreateList(request);
        RequestParams[] args = request.getParams();
        byte[][] bytes = (byte[][])Arrays.stream(args, 1, args.length).map(RequestParams::getByteArray).toArray(x$0 -> new byte[x$0][]);
        data.leftAdd(bytes);
        request.getOutputProtocol().writer(((List)data.getData()).size());
    }

    public void lpushx(RedisRequest request) throws IOException {
        request.expectArgumentsCountGE(2);
        Optional<ListData> opt = this.getList(request);
        if (opt.isPresent()) {
            RequestParams[] args = request.getParams();
            byte[][] bytes = (byte[][])Arrays.stream(args, 1, args.length).map(RequestParams::getByteArray).toArray(x$0 -> new byte[x$0][]);
            opt.get().leftAdd(bytes);
        }
        request.getOutputProtocol().writer(opt.map(e -> ((List)e.getData()).size()).orElse(0));
    }

    public void lrange(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        Optional<ListData> opt = this.getList(request);
        Object range = new byte[][]{};
        if (opt.isPresent()) {
            RequestParams[] args = request.getParams();
            range = opt.get().range(args[1].byteArray2int(), args[2].byteArray2int());
        }
        request.getOutputProtocol().writerMulti((byte[][])range);
    }

    public void lrem(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        Optional<ListData> opt = this.getList(request);
        int len = 0;
        if (opt.isPresent()) {
            RequestParams[] args = request.getParams();
            len = opt.get().remove(args[1].byteArray2int(), args[2].getByteArray());
        }
        request.getOutputProtocol().writer(len);
    }

    public void lset(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        RequestParams[] args = request.getParams();
        Optional<ListData> opt = this.getList(request);
        if (opt.isPresent()) {
            String index = args[1].getByteArray2string();
            try {
                ((List)opt.get().getData()).set(Integer.parseInt(index), args[2].toBytes());
                request.getOutputProtocol().writer(Protocol.Keyword.OK.name());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, "Array Index Out Of Bounds");
            }
        } else {
            request.getOutputProtocol().writerError(RedisOutputProtocol.Level.ERR, "NO LIST");
        }
    }

    public void ltrim(RedisRequest request) throws IOException {
        request.expectArgumentsCount(3);
        Optional<ListData> opt = this.getList(request);
        RequestParams[] args = request.getParams();
        opt.ifPresent(e -> e.trim(args[1].byteArray2int(), args[2].byteArray2int()));
        request.getOutputProtocol().writer(Protocol.Keyword.OK.name());
    }

    public void rpop(RedisRequest request) throws IOException {
        request.expectArgumentsCount(1);
        Optional<ListData> opt = this.getList(request);
        if (opt.isPresent()) {
            try {
                Optional<Bytes> rm = opt.get().rightPop();
                request.getOutputProtocol().writer((Bytes)rm.orElse(null));
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        request.getOutputProtocol().writerNull();
    }

    public void rpoplpush(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        HashKey target = request.getParams()[1].byteArray2hashKey();
        Optional<ListData> opt = this.getList(request);
        Bytes data = opt.flatMap(e -> e.pop2push(request.getDatabase(), target)).orElse(null);
        request.getOutputProtocol().writer(data);
    }

    public void rpush(RedisRequest request) throws IOException {
        request.expectArgumentsCountBigger(1);
        ListData list = this.getOrCreateList(request);
        RequestParams[] args = request.getParams();
        byte[][] bytes = (byte[][])Arrays.stream(args, 1, args.length).map(RequestParams::getByteArray).toArray(x$0 -> new byte[x$0][]);
        list.rightAdd(bytes);
        request.getOutputProtocol().writer(((List)list.getData()).size());
    }

    public void rpushx(RedisRequest request) throws IOException {
        request.expectArgumentsCount(2);
        Optional<ListData> opt = this.getList(request);
        RequestParams[] args = request.getParams();
        if (opt.isPresent()) {
            byte[] val = args[1].getByteArray();
            opt.get().rightAdd(new byte[][]{val});
        }
        request.getOutputProtocol().writer(opt.map(e -> ((List)e.getData()).size()).orElse(0));
    }

    private Optional<ListData> getList(RedisRequest request) {
        RequestParams[] args = request.getParams();
        HashKey key = new HashKey(args[0].getByteArray());
        RedisDatabase db = request.getDatabase();
        return db.get(key, ListData.class);
    }

    private ListData getOrCreateList(RedisRequest request) {
        return this.getOrCreateList(request, 0);
    }

    private ListData getOrCreateList(RedisRequest request, int index) {
        HashKey key = new HashKey(request.getParams()[index].getByteArray());
        Optional<ListData> opt = this.getList(request);
        if (!opt.isPresent()) {
            ListData d = new ListData();
            ListData origin = request.getDatabase().putIfAbsent(key, d);
            opt = Optional.of(origin == null ? d : origin);
        }
        return opt.get();
    }

    public abstract class AddListener
    implements Observer {
        private final Timer timer = new Timer();
        RedisRequest request;
        List<ListData> listeners = new ArrayList<ListData>();
        private boolean over = false;
        private final Date timeoutAT;

        public AddListener(RedisRequest request, long timeoutSeconds) {
            this.timeoutAT = new Date(System.currentTimeMillis() + timeoutSeconds * 1000L);
            this.request = RedisRequest.warp(request, request.getCommand(), request.getParams());
        }

        @Override
        public void update(Observable o, Object arg) {
            long time;
            if (!this.over && (time = this.timeoutAT.getTime() - System.currentTimeMillis()) > 0L) {
                this.over = true;
                this.request.getServer().getSchema().submit(() -> this.changeRunning(time));
                this.clear();
            }
        }

        public abstract void changeRunning(long var1);

        public void clear() {
            this.listeners.forEach(e -> e.unsubscribe(this));
            this.over = true;
        }

        public AddListener subscribe(ListData listener) {
            this.listeners.add(listener);
            listener.subscribe(this);
            return this;
        }

        public void timerSchedule(final IoConsumer<AddListener> consumer) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!AddListener.this.over) {
                        try {
                            AddListener.this.over = true;
                            consumer.accept(AddListener.this);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Write time out `NULL` error!", e);
                        }
                        finally {
                            AddListener.this.clear();
                        }
                    }
                }
            }, this.timeoutAT);
        }
    }
}

