/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.Parser;
import com.github.tomakehurst.wiremock.admin.ParserBuilder;
import com.github.tomakehurst.wiremock.admin.Renderer;
import com.github.tomakehurst.wiremock.admin.RendererBuilder;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdminUriTemplate {
    static final Pattern SPECIAL_SYMBOL_REGEX = Pattern.compile("(?:\\{(?<variable>[^}]+)\\})|(?<wildcard>\\*\\*)");
    private final String templateString;
    private final Parser parser;
    private final Renderer renderer;

    public AdminUriTemplate(String templateString) {
        String text;
        this.templateString = templateString;
        Matcher matcher = SPECIAL_SYMBOL_REGEX.matcher(templateString);
        ParserBuilder parserBuilder = new ParserBuilder();
        RendererBuilder rendererBuilder = new RendererBuilder();
        int last = 0;
        while (matcher.find()) {
            String wildcard;
            text = templateString.substring(last, matcher.start());
            parserBuilder.addStatic(text);
            rendererBuilder.addStatic(text);
            String variable = matcher.group("variable");
            if (variable != null) {
                parserBuilder.addVariable(variable);
                rendererBuilder.addVariable(variable);
            }
            if ((wildcard = matcher.group("wildcard")) != null) {
                parserBuilder.addWildcard();
                rendererBuilder.addWildcard();
            }
            last = matcher.end();
        }
        text = templateString.substring(last);
        parserBuilder.addStatic(text);
        rendererBuilder.addStatic(text);
        this.parser = parserBuilder.build();
        this.renderer = rendererBuilder.build();
    }

    public boolean matches(String url) {
        return this.parser.matches(url);
    }

    public PathParams parse(String url) {
        return this.parser.parse(url);
    }

    public String render(PathParams pathParams) {
        return this.renderer.render(pathParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminUriTemplate that = (AdminUriTemplate)o;
        return Objects.equal((Object)this.templateString, (Object)that.templateString);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateString});
    }
}

