/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import wiremock.com.google.common.io.Resources;

public class KeyStoreSettings {
    public static final KeyStoreSettings NO_STORE = new KeyStoreSettings(null, null);
    private final String path;
    private final String password;

    public KeyStoreSettings(String path, String password) {
        this.path = path;
        this.password = password;
    }

    public String path() {
        return this.path;
    }

    public String password() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadStore() {
        InputStream instream = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            instream = this.createInputStream();
            trustStore.load(instream, this.password.toCharArray());
            KeyStore keyStore = trustStore;
            return keyStore;
        }
        catch (Exception e) {
            KeyStore keyStore = Exceptions.throwUnchecked(e, KeyStore.class);
            return keyStore;
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException ioe) {
                    Exceptions.throwUnchecked(ioe);
                }
            }
        }
    }

    private InputStream createInputStream() throws IOException {
        if (new File(this.path).isFile()) {
            return new FileInputStream(this.path);
        }
        return Resources.getResource(this.path).openStream();
    }
}

