/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot;

import org.apache.shiro.spring.boot.ShiroBizAnnotationProperties;
import org.apache.shiro.spring.config.AbstractShiroAnnotationProcessorConfiguration;
import org.apache.shiro.util.StringUtils;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@AutoConfigureBefore(name={"org.apache.shiro.spring.boot.autoconfigure.ShiroAnnotationProcessorAutoConfiguration"})
@Configuration
@ConditionalOnProperty(prefix="shiro.annotations", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ShiroBizAnnotationProperties.class})
public class ShiroBizAnnotationProcessorAutoConfiguration
extends AbstractShiroAnnotationProcessorConfiguration {
    @Autowired
    private ShiroBizAnnotationProperties properties;

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = super.defaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(this.properties.isProxyTargetClass());
        advisorAutoProxyCreator.setExposeProxy(this.properties.isExposeProxy());
        advisorAutoProxyCreator.setFrozen(this.properties.isFrozen());
        advisorAutoProxyCreator.setOpaque(this.properties.isOpaque());
        if (this.properties.isUsePrefix() && StringUtils.hasText((String)this.properties.getAdvisorBeanNamePrefix())) {
            advisorAutoProxyCreator.setUsePrefix(this.properties.isUsePrefix());
            advisorAutoProxyCreator.setAdvisorBeanNamePrefix(this.properties.getAdvisorBeanNamePrefix());
        }
        return advisorAutoProxyCreator;
    }
}

