/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="shiro")
public class ShiroBizProperties {
    public static final String PREFIX = "shiro";
    public static final long DEFAULT_CAPTCHA_TIMEOUT = 60000L;
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    public static final long DEFAULT_GLOBAL_SESSION_TIMEOUT = 1800000L;
    private static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 30000L;
    public static final List<String> DEFAULT_IGNORED = Arrays.asList("/**/favicon.ico", "/assets/**", "/webjars/**");
    private String activeSessionsCacheName = "shiro-activeSessionCache";
    private boolean authorizationCachingEnabled = false;
    private String authorizationCacheName = "shiro-authorizationCache";
    private boolean authenticationCachingEnabled = false;
    private String authenticationCacheName = "shiro-authenticationCache";
    private boolean cachingEnabled = false;
    private boolean captchaEnabled = false;
    private String captchaParamName = "captcha";
    protected int credentialsRetryTimesLimit = 5;
    protected String credentialsRetryCacheName = "shiro-credentialsRetryCache";
    private Map<String, String> defaultRolePermissions = new LinkedHashMap<String, String>();
    private boolean enabled = false;
    private String failureUrl;
    private Map<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
    private String loginUrl = "/login.jsp";
    private boolean postOnlyLogout = false;
    private String redirectUrl = "/";
    private String retryTimesKeyAttribute = "shiroLoginFailureRetries";
    private int retryTimesWhenAccessDenied = 3;
    private boolean sessionCachingEnabled = false;
    private boolean sessionCreationEnabled = true;
    private String sessionDequeCacheName = "shiro-sessionDequeCache";
    private boolean kickoutFirst = false;
    private int sessionMaximumKickout = 1;
    private boolean sessionStorageEnabled = true;
    private boolean sessionStateless = false;
    private long sessionTimeout = 1800000L;
    private long sessionValidationInterval = 30000L;
    private boolean sessionValidationSchedulerEnabled = true;
    private String successUrl = "/";
    private String unauthorizedUrl;
    private boolean uniqueSessin = false;
    private boolean userNativeSessionManager = false;

    public ShiroBizProperties() {
        for (String ingored : DEFAULT_IGNORED) {
            this.filterChainDefinitionMap.put(ingored, "anon");
        }
    }

    public String getActiveSessionsCacheName() {
        return this.activeSessionsCacheName;
    }

    public void setActiveSessionsCacheName(String activeSessionsCacheName) {
        this.activeSessionsCacheName = activeSessionsCacheName;
    }

    public String getAuthorizationCacheName() {
        return this.authorizationCacheName;
    }

    public void setAuthorizationCacheName(String authorizationCacheName) {
        this.authorizationCacheName = authorizationCacheName;
    }

    public boolean isAuthorizationCachingEnabled() {
        return this.isCachingEnabled() && this.authorizationCachingEnabled;
    }

    public void setAuthorizationCachingEnabled(boolean authenticationCachingEnabled) {
        this.authorizationCachingEnabled = authenticationCachingEnabled;
        if (authenticationCachingEnabled) {
            this.setCachingEnabled(true);
        }
    }

    public boolean isAuthenticationCachingEnabled() {
        return this.authenticationCachingEnabled && this.isCachingEnabled();
    }

    public void setAuthenticationCachingEnabled(boolean authenticationCachingEnabled) {
        this.authenticationCachingEnabled = authenticationCachingEnabled;
        if (authenticationCachingEnabled) {
            this.setCachingEnabled(true);
        }
    }

    public String getAuthenticationCacheName() {
        return this.authenticationCacheName;
    }

    public void setAuthenticationCacheName(String authenticationCacheName) {
        this.authenticationCacheName = authenticationCacheName;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    public void setCaptchaEnabled(boolean captchaEnabled) {
        this.captchaEnabled = captchaEnabled;
    }

    public String getCaptchaParamName() {
        return this.captchaParamName;
    }

    public void setCaptchaParamName(String captchaParamName) {
        this.captchaParamName = captchaParamName;
    }

    public int getCredentialsRetryTimesLimit() {
        return this.credentialsRetryTimesLimit;
    }

    public void setCredentialsRetryTimesLimit(int credentialsRetryTimesLimit) {
        this.credentialsRetryTimesLimit = credentialsRetryTimesLimit;
    }

    public String getCredentialsRetryCacheName() {
        return this.credentialsRetryCacheName;
    }

    public void setCredentialsRetryCacheName(String credentialsRetryCacheName) {
        this.credentialsRetryCacheName = credentialsRetryCacheName;
    }

    public Map<String, String> getDefaultRolePermissions() {
        return this.defaultRolePermissions;
    }

    public void setDefaultRolePermissions(Map<String, String> defaultRolePermissions) {
        this.defaultRolePermissions = defaultRolePermissions;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public Map<String, String> getFilterChainDefinitionMap() {
        return this.filterChainDefinitionMap;
    }

    public void setFilterChainDefinitionMap(Map<String, String> filterChainDefinitionMap) {
        this.filterChainDefinitionMap = filterChainDefinitionMap;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public boolean isPostOnlyLogout() {
        return this.postOnlyLogout;
    }

    public void setPostOnlyLogout(boolean postOnlyLogout) {
        this.postOnlyLogout = postOnlyLogout;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getRetryTimesKeyAttribute() {
        return this.retryTimesKeyAttribute;
    }

    public void setRetryTimesKeyAttribute(String retryTimesKeyAttribute) {
        this.retryTimesKeyAttribute = retryTimesKeyAttribute;
    }

    public int getRetryTimesWhenAccessDenied() {
        return this.retryTimesWhenAccessDenied;
    }

    public void setRetryTimesWhenAccessDenied(int retryTimesWhenAccessDenied) {
        this.retryTimesWhenAccessDenied = retryTimesWhenAccessDenied;
    }

    public boolean isSessionCachingEnabled() {
        return this.isCachingEnabled() && this.sessionCachingEnabled;
    }

    public void setSessionCachingEnabled(boolean sessionCachingEnabled) {
        this.sessionCachingEnabled = sessionCachingEnabled;
        if (sessionCachingEnabled) {
            this.setCachingEnabled(true);
        }
    }

    public boolean isSessionCreationEnabled() {
        return this.sessionCreationEnabled;
    }

    public void setSessionCreationEnabled(boolean sessionCreationEnabled) {
        this.sessionCreationEnabled = sessionCreationEnabled;
    }

    public String getSessionDequeCacheName() {
        return this.sessionDequeCacheName;
    }

    public void setSessionDequeCacheName(String sessionDequeCacheName) {
        this.sessionDequeCacheName = sessionDequeCacheName;
    }

    public boolean isKickoutFirst() {
        return this.kickoutFirst;
    }

    public void setKickoutFirst(boolean kickoutFirst) {
        this.kickoutFirst = kickoutFirst;
    }

    public int getSessionMaximumKickout() {
        return this.sessionMaximumKickout;
    }

    public void setSessionMaximumKickout(int sessionMaximumKickout) {
        this.sessionMaximumKickout = sessionMaximumKickout;
    }

    public boolean isSessionStorageEnabled() {
        return this.sessionStorageEnabled;
    }

    public void setSessionStorageEnabled(boolean sessionStorageEnabled) {
        this.sessionStorageEnabled = sessionStorageEnabled;
    }

    public boolean isSessionStateless() {
        return this.sessionStateless;
    }

    public void setSessionStateless(boolean sessionStateless) {
        this.sessionStateless = sessionStateless;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public boolean isSessionValidationSchedulerEnabled() {
        return this.sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationSchedulerEnabled(boolean sessionValidationSchedulerEnabled) {
        this.sessionValidationSchedulerEnabled = sessionValidationSchedulerEnabled;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public String getUnauthorizedUrl() {
        return this.unauthorizedUrl;
    }

    public void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = unauthorizedUrl;
    }

    public boolean isUniqueSessin() {
        return this.uniqueSessin;
    }

    public void setUniqueSessin(boolean uniqueSessin) {
        this.uniqueSessin = uniqueSessin;
    }

    public boolean isUserNativeSessionManager() {
        return this.userNativeSessionManager;
    }

    public void setUserNativeSessionManager(boolean userNativeSessionManager) {
        this.userNativeSessionManager = userNativeSessionManager;
    }
}

