/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.biz.authc.pam.DefaultModularRealmAuthenticator;
import org.apache.shiro.biz.authz.permission.BitAndWildPermissionResolver;
import org.apache.shiro.biz.authz.permission.DefaultRolePermissionResolver;
import org.apache.shiro.biz.realm.AuthorizingRealmListener;
import org.apache.shiro.biz.session.DefaultSessionListener;
import org.apache.shiro.biz.session.mgt.SimpleOnlineSessionFactory;
import org.apache.shiro.biz.web.mgt.SessionCreationEnabledSubjectFactory;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.AbstractNativeSessionManager;
import org.apache.shiro.session.mgt.AbstractSessionManager;
import org.apache.shiro.session.mgt.AbstractValidatingSessionManager;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.apache.shiro.session.mgt.eis.JavaUuidSessionIdGenerator;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.apache.shiro.spring.boot.ShiroBizProperties;
import org.apache.shiro.spring.web.config.AbstractShiroWebConfiguration;
import org.apache.shiro.spring.web.config.DefaultShiroFilterChainDefinition;
import org.apache.shiro.spring.web.config.ShiroFilterChainDefinition;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@AutoConfigureBefore(name={"org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration"})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="shiro", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ShiroBizProperties.class})
public class ShiroBizWebAutoConfiguration
extends AbstractShiroWebConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private ShiroBizProperties bizProperties;

    @Bean(value={"realmListeners"})
    @ConditionalOnMissingBean(name={"realmListeners"})
    public List<AuthorizingRealmListener> realmListeners() {
        ArrayList<AuthorizingRealmListener> realmListeners = new ArrayList<AuthorizingRealmListener>();
        Map beansOfType = this.getApplicationContext().getBeansOfType(AuthorizingRealmListener.class);
        if (!ObjectUtils.isEmpty((Object)beansOfType)) {
            Iterator ite = beansOfType.entrySet().iterator();
            while (ite.hasNext()) {
                realmListeners.add((AuthorizingRealmListener)ite.next().getValue());
            }
        }
        return realmListeners;
    }

    @Bean(value={"sessionListeners"})
    @ConditionalOnMissingBean(name={"sessionListeners"})
    public List<SessionListener> sessionListeners() {
        LinkedList sessionListeners = Lists.newLinkedList();
        Map beansOfType = this.getApplicationContext().getBeansOfType(SessionListener.class);
        if (!ObjectUtils.isEmpty((Object)beansOfType)) {
            Iterator ite = beansOfType.entrySet().iterator();
            while (ite.hasNext()) {
                sessionListeners.add(ite.next().getValue());
            }
        }
        DefaultSessionListener defSessionListener = new DefaultSessionListener();
        sessionListeners.add(defSessionListener);
        return sessionListeners;
    }

    @Bean(value={"authenticationListeners"})
    @ConditionalOnMissingBean(name={"authenticationListeners"})
    public List<AuthenticationListener> authenticationListeners() {
        LinkedList authenticationListeners = Lists.newLinkedList();
        Map beansOfType = this.getApplicationContext().getBeansOfType(AuthenticationListener.class);
        if (!ObjectUtils.isEmpty((Object)beansOfType)) {
            Iterator ite = beansOfType.entrySet().iterator();
            while (ite.hasNext()) {
                authenticationListeners.add(ite.next().getValue());
            }
        }
        return authenticationListeners;
    }

    @Bean
    @ConditionalOnMissingBean
    public PermissionResolver permissionResolver() {
        return new BitAndWildPermissionResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    public RolePermissionResolver rolePermissionResolver(ShiroBizProperties bizProperties) {
        DefaultRolePermissionResolver permissionResolver = new DefaultRolePermissionResolver();
        permissionResolver.setDefaultRolePermissions(bizProperties.getDefaultRolePermissions());
        return permissionResolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public CredentialsMatcher credentialsMatcher() {
        return new AllowAllCredentialsMatcher();
    }

    @Bean
    @ConditionalOnMissingBean
    protected Authenticator authenticator() {
        DefaultModularRealmAuthenticator authenticator = new DefaultModularRealmAuthenticator();
        authenticator.setAuthenticationStrategy(this.authenticationStrategy());
        authenticator.setAuthenticationListeners(this.authenticationListeners());
        return authenticator;
    }

    @Bean
    @ConditionalOnMissingBean
    protected SessionFactory sessionFactory() {
        return new SimpleOnlineSessionFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    protected SessionIdGenerator sessionIdGenerator() {
        return new JavaUuidSessionIdGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    protected SessionDAO sessionDAO() {
        if (this.useNativeSessionManager && this.bizProperties.isSessionCachingEnabled() && this.cacheManager != null) {
            EnterpriseCacheSessionDAO sessionDAO = new EnterpriseCacheSessionDAO();
            sessionDAO.setCacheManager(this.cacheManager);
            sessionDAO.setActiveSessionsCacheName(this.bizProperties.getActiveSessionsCacheName());
            sessionDAO.setSessionIdGenerator(this.sessionIdGenerator());
            return sessionDAO;
        }
        return new MemorySessionDAO();
    }

    @Bean
    @ConditionalOnMissingBean
    protected SubjectDAO subjectDAO() {
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        subjectDAO.setSessionStorageEvaluator(this.sessionStorageEvaluator());
        return subjectDAO;
    }

    @Bean
    @ConditionalOnMissingBean
    protected SessionStorageEvaluator sessionStorageEvaluator() {
        DefaultSessionStorageEvaluator sessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        sessionStorageEvaluator.setSessionStorageEnabled(this.bizProperties.isSessionStorageEnabled());
        return sessionStorageEvaluator;
    }

    @Bean
    @ConditionalOnMissingBean
    protected SessionManager sessionManager() {
        AbstractNativeSessionManager sManager;
        SessionManager sessionManager = super.sessionManager();
        if (sessionManager instanceof AbstractSessionManager) {
            AbstractSessionManager absSessionManager = (AbstractSessionManager)sessionManager;
            absSessionManager.setGlobalSessionTimeout(this.bizProperties.getSessionTimeout());
        }
        if (sessionManager instanceof AbstractNativeSessionManager) {
            sManager = (AbstractNativeSessionManager)sessionManager;
            sManager.setSessionListeners(this.sessionListeners());
        }
        if (sessionManager instanceof AbstractValidatingSessionManager) {
            sManager = (AbstractValidatingSessionManager)sessionManager;
            sManager.setSessionValidationInterval(this.bizProperties.getSessionValidationInterval());
            sManager.setSessionValidationSchedulerEnabled(this.bizProperties.isSessionValidationSchedulerEnabled());
        }
        if (sessionManager instanceof DefaultSessionManager) {
            DefaultSessionManager defSessionManager = (DefaultSessionManager)sessionManager;
            if (this.cacheManager != null) {
                defSessionManager.setCacheManager(this.cacheManager);
            }
            defSessionManager.setSessionDAO(this.sessionDAO());
            return defSessionManager;
        }
        return sessionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    protected SessionsSecurityManager securityManager(List<Realm> realms) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setAuthenticator(this.authenticator());
        securityManager.setAuthorizer(this.authorizer());
        if (this.cacheManager != null) {
            securityManager.setCacheManager(this.cacheManager);
        }
        securityManager.setEventBus(this.eventBus);
        securityManager.setRealms(realms);
        securityManager.setRememberMeManager(this.rememberMeManager());
        securityManager.setSessionManager(this.sessionManager());
        securityManager.setSubjectDAO(this.subjectDAO());
        securityManager.setSubjectFactory(this.subjectFactory());
        return securityManager;
    }

    @Bean
    @ConditionalOnMissingBean
    protected SubjectFactory subjectFactory() {
        return new SessionCreationEnabledSubjectFactory(this.bizProperties.isSessionCreationEnabled());
    }

    @Bean
    @ConditionalOnMissingBean
    protected ShiroFilterChainDefinition shiroFilterChainDefinition() {
        DefaultShiroFilterChainDefinition chainDefinition = new DefaultShiroFilterChainDefinition();
        Map<String, String> pathDefinitions = this.bizProperties.getFilterChainDefinitionMap();
        if (MapUtils.isNotEmpty(pathDefinitions)) {
            chainDefinition.addPathDefinitions(pathDefinitions);
            return chainDefinition;
        }
        chainDefinition.addPathDefinition("/**", "authc");
        return chainDefinition;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ShiroBizProperties getBizProperties() {
        return this.bizProperties;
    }

    public void setBizProperties(ShiroBizProperties bizProperties) {
        this.bizProperties = bizProperties;
    }
}

