/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot;

import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.apache.shiro.biz.authz.principal.ShiroPrincipal;
import org.apache.shiro.biz.utils.StringUtils;
import org.apache.shiro.biz.web.filter.HttpServletHeaderProperties;
import org.apache.shiro.biz.web.filter.HttpServletReferrerProperties;
import org.apache.shiro.biz.web.filter.HttpServletRequestEscapeHtml4Filter;
import org.apache.shiro.biz.web.filter.HttpServletRequestHeaderFilter;
import org.apache.shiro.biz.web.filter.HttpServletRequestMethodFilter;
import org.apache.shiro.biz.web.filter.HttpServletRequestReferrerFilter;
import org.apache.shiro.biz.web.filter.HttpServletSessionDequeFilter;
import org.apache.shiro.biz.web.filter.HttpServletSessionExpiredFilter;
import org.apache.shiro.biz.web.filter.HttpServletSessionStatusFilter;
import org.apache.shiro.biz.web.filter.authc.AuthenticatingFailureCounter;
import org.apache.shiro.biz.web.filter.authc.AuthenticatingFailureRequestCounter;
import org.apache.shiro.biz.web.filter.authc.AuthenticatingFailureSessionCounter;
import org.apache.shiro.biz.web.filter.authc.listener.LogoutListener;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.boot.ShiroBizProperties;
import org.apache.shiro.spring.boot.biz.ShiroBizFilterFactoryBean;
import org.apache.shiro.spring.boot.biz.ShiroHttpServletHeaderProperties;
import org.apache.shiro.spring.boot.biz.ShiroHttpServletReferrerProperties;
import org.apache.shiro.spring.boot.biz.authc.BizLogoutFilter;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.spring.web.config.AbstractShiroWebFilterConfiguration;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(name={"org.apache.shiro.spring.config.web.autoconfigure.ShiroWebFilterConfiguration"})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="shiro", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ShiroBizProperties.class, ShiroHttpServletHeaderProperties.class, ShiroHttpServletReferrerProperties.class})
public class ShiroBizWebFilterConfiguration
extends AbstractShiroWebFilterConfiguration {
    @Autowired
    private ShiroBizProperties bizProperties;

    @Bean(value={"logout"})
    @ConditionalOnMissingBean(name={"logout"})
    public FilterRegistrationBean<BizLogoutFilter> logoutFilter(ObjectProvider<LogoutListener> logoutListenerProvider) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        BizLogoutFilter logoutFilter = new BizLogoutFilter();
        logoutFilter.setLogoutListeners(logoutListenerProvider.stream().collect(Collectors.toList()));
        logoutFilter.setPostOnlyLogout(this.bizProperties.isPostOnlyLogout());
        logoutFilter.setRedirectUrl(this.bizProperties.getRedirectUrl());
        registration.setFilter((Filter)logoutFilter);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"escapeHtml4"})
    @ConditionalOnMissingBean(name={"escapeHtml4"})
    public FilterRegistrationBean<HttpServletRequestEscapeHtml4Filter> escapeHtml4Filter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HttpServletRequestEscapeHtml4Filter());
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"headers"})
    @ConditionalOnMissingBean(name={"headers"})
    public FilterRegistrationBean<HttpServletRequestHeaderFilter> headerFilter(ShiroHttpServletHeaderProperties properties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        HttpServletRequestHeaderFilter headFilter = new HttpServletRequestHeaderFilter((HttpServletHeaderProperties)properties);
        registration.setFilter((Filter)headFilter);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"methods"})
    @ConditionalOnMissingBean(name={"methods"})
    public FilterRegistrationBean<HttpServletRequestMethodFilter> methodFilter(ShiroHttpServletHeaderProperties properties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        HttpServletRequestMethodFilter methodFilter = new HttpServletRequestMethodFilter();
        methodFilter.setAllowedHTTPMethods(StringUtils.tokenizeToStringArray((String)properties.getAccessControlAllowMethods()));
        registration.setFilter((Filter)methodFilter);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"referrers"})
    @ConditionalOnMissingBean(name={"referrers"})
    public FilterRegistrationBean<HttpServletRequestReferrerFilter> referrerFilter(ShiroHttpServletReferrerProperties properties) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        HttpServletRequestReferrerFilter referrerFilter = new HttpServletRequestReferrerFilter((HttpServletReferrerProperties)properties);
        registration.setFilter((Filter)referrerFilter);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"sessionStatus"})
    @ConditionalOnMissingBean(name={"sessionStatus"})
    public FilterRegistrationBean<HttpServletSessionStatusFilter> sessionOnlineFilter(SessionManager sessionManager) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        HttpServletSessionStatusFilter sessionOnlineFilter = new HttpServletSessionStatusFilter();
        sessionOnlineFilter.setLoginUrl(this.bizProperties.getLoginUrl());
        sessionOnlineFilter.setSessionManager(sessionManager);
        registration.setFilter((Filter)sessionOnlineFilter);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"sessionDeque"})
    @ConditionalOnMissingBean(name={"sessionDeque"})
    public FilterRegistrationBean<HttpServletSessionDequeFilter> sessionDequeFilter(CacheManager cacheManager, SessionManager sessionManager) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        HttpServletSessionDequeFilter sessionDequeFilter = new HttpServletSessionDequeFilter(){

            protected String getSessionDequeCacheKey(Object principal) {
                ShiroPrincipal sp = (ShiroPrincipal)principal;
                return sp.getUserid();
            }
        };
        sessionDequeFilter.setCacheManager(cacheManager);
        sessionDequeFilter.setKickoutFirst(this.bizProperties.isKickoutFirst());
        sessionDequeFilter.setSessionDequeCacheName(this.bizProperties.getSessionDequeCacheName());
        sessionDequeFilter.setSessionManager(sessionManager);
        sessionDequeFilter.setSessionMaximumKickout(this.bizProperties.getSessionMaximumKickout());
        sessionDequeFilter.setRedirectUrl(this.bizProperties.getRedirectUrl());
        registration.setFilter((Filter)sessionDequeFilter);
        registration.setEnabled(false);
        return registration;
    }

    @Bean(value={"sessionExpired"})
    @ConditionalOnMissingBean(name={"sessionExpired"})
    public FilterRegistrationBean<HttpServletSessionExpiredFilter> sessionExpiredFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HttpServletSessionExpiredFilter());
        registration.setEnabled(false);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticatingFailureCounter authcFailureCounter() {
        if (this.bizProperties.isSessionStateless()) {
            return new AuthenticatingFailureRequestCounter();
        }
        return new AuthenticatingFailureSessionCounter();
    }

    @Bean
    @ConditionalOnMissingBean
    protected ShiroFilterFactoryBean shiroFilterFactoryBean() {
        ShiroBizFilterFactoryBean filterFactoryBean = new ShiroBizFilterFactoryBean();
        filterFactoryBean.setLoginUrl(this.bizProperties.getLoginUrl());
        filterFactoryBean.setSuccessUrl(this.bizProperties.getSuccessUrl());
        filterFactoryBean.setUnauthorizedUrl(this.bizProperties.getUnauthorizedUrl());
        filterFactoryBean.setSecurityManager(this.securityManager);
        filterFactoryBean.setFilterChainDefinitionMap(this.shiroFilterChainDefinition.getFilterChainMap());
        return filterFactoryBean;
    }

    @Bean(name={"filterShiroFilterRegistrationBean"})
    @ConditionalOnMissingBean(name={"filterShiroFilterRegistrationBean"})
    protected FilterRegistrationBean<AbstractShiroFilter> filterShiroFilterRegistrationBean() throws Exception {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)((AbstractShiroFilter)this.shiroFilterFactoryBean().getObject()));
        filterRegistrationBean.setOrder(Integer.MAX_VALUE);
        return filterRegistrationBean;
    }
}

