/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.actuate;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleOnlineSession;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="shiro")
public class ShiroEndpoint {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
    private final SessionDAO sessionDAO;

    public ShiroEndpoint(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    @ReadOperation
    public ApplicationShiroSessions shiroSessions() {
        HashMap shiroSessions = Maps.newHashMap();
        Collection sessions = this.sessionDAO.getActiveSessions();
        if (sessions != null) {
            for (Session session : sessions) {
                SessionDescriptor sessionDesc = new SessionDescriptor(session.getId(), session.getHost(), dateFormat.format(session.getStartTimestamp()), dateFormat.format(session.getLastAccessTime()), session.getTimeout());
                if (session instanceof SimpleOnlineSession) {
                    SimpleOnlineSession onlineSession = (SimpleOnlineSession)session;
                    sessionDesc.setStatus(onlineSession.getStatus().getInfo());
                    sessionDesc.setUserAgent(onlineSession.getUserAgent());
                    sessionDesc.setSystemHost(onlineSession.getSystemHost());
                }
                if (Boolean.TRUE.equals(session.getAttribute((Object)"session-force-logout"))) {
                    sessionDesc.setStatus(SimpleOnlineSession.OnlineStatus.FORCE_LOGOUT.getInfo());
                }
                shiroSessions.put(session.getId(), sessionDesc);
            }
        }
        return new ApplicationShiroSessions(shiroSessions);
    }

    @ReadOperation
    public SessionDescriptor getSession(@Selector String sessionId) {
        Session session = this.sessionDAO.readSession((Serializable)((Object)sessionId));
        if (session == null) {
            return null;
        }
        return new SessionDescriptor(session);
    }

    @WriteOperation
    public boolean forceLogout(@Selector String sessionId) {
        try {
            Session session = this.sessionDAO.readSession((Serializable)((Object)sessionId));
            if (session != null) {
                if (session instanceof SimpleOnlineSession) {
                    SimpleOnlineSession onlineSession = (SimpleOnlineSession)session;
                    onlineSession.setStatus(SimpleOnlineSession.OnlineStatus.FORCE_LOGOUT);
                }
                session.setAttribute((Object)"session-force-logout", (Object)Boolean.TRUE);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class SessionDescriptor {
        private Serializable sessionId;
        private String host;
        private String startTimestamp;
        private String lastAccessTime;
        private long timeout;
        protected String userAgent;
        protected String systemHost;
        protected String status;
        private String forceLogout;

        public SessionDescriptor() {
        }

        public SessionDescriptor(Serializable sessionId, String host, String startTimestamp, String lastAccessTime, long timeout) {
            this.sessionId = sessionId;
            this.host = host;
            this.startTimestamp = startTimestamp;
            this.lastAccessTime = lastAccessTime;
            this.timeout = timeout;
        }

        public SessionDescriptor(Session session) {
            this.sessionId = session.getId();
            this.host = session.getHost();
            this.startTimestamp = dateFormat.format(session.getStartTimestamp());
            this.lastAccessTime = dateFormat.format(session.getLastAccessTime());
            this.timeout = session.getTimeout();
            if (session instanceof SimpleOnlineSession) {
                SimpleOnlineSession onlineSession = (SimpleOnlineSession)session;
                this.status = onlineSession.getStatus().getInfo();
            }
            if (Boolean.TRUE.equals(session.getAttribute((Object)"session-force-logout"))) {
                this.status = SimpleOnlineSession.OnlineStatus.FORCE_LOGOUT.getInfo();
            }
        }

        public Serializable getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(Serializable sessionId) {
            this.sessionId = sessionId;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getStartTimestamp() {
            return this.startTimestamp;
        }

        public void setStartTimestamp(String startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public String getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void setLastAccessTime(String lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public String getSystemHost() {
            return this.systemHost;
        }

        public void setSystemHost(String systemHost) {
            this.systemHost = systemHost;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getForceLogout() {
            return this.forceLogout;
        }

        public void setForceLogout(String forceLogout) {
            this.forceLogout = forceLogout;
        }
    }

    public static final class ApplicationShiroSessions {
        private final Map<Serializable, SessionDescriptor> sessions;

        private ApplicationShiroSessions(Map<Serializable, SessionDescriptor> shiroSessions) {
            this.sessions = shiroSessions;
        }

        public Map<Serializable, SessionDescriptor> getSessions() {
            return this.sessions;
        }
    }
}

