/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.actuate;

import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.boot.ShiroBizWebAutoConfiguration;
import org.apache.shiro.spring.boot.actuate.ShiroEndpoint;
import org.apache.shiro.subject.Subject;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Subject.class, HealthIndicator.class, EndpointAutoConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="shiro")
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={ShiroBizWebAutoConfiguration.class, HealthIndicatorAutoConfiguration.class})
public class ShiroEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public ShiroEndpoint shiroEndpoint(SessionDAO sessionDAO) {
        return new ShiroEndpoint(sessionDAO);
    }
}

