/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.cache;

import net.sf.ehcache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.spring.boot.cache.ShiroEhCache2CacheProperties;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AbstractCachingConfiguration.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnProperty(prefix="shiro.cache", value={"type"}, havingValue="ehcache")
@EnableConfigurationProperties(value={ShiroEhCache2CacheProperties.class})
public class ShiroEhCache2CacheConfiguration {
    @Bean
    public org.apache.shiro.cache.CacheManager shiroCacheManager(ShiroEhCache2CacheProperties properties, @Autowired(required=false) CacheManager cacheManager) {
        EhCacheManager shiroCacheManager = new EhCacheManager();
        shiroCacheManager.setCacheManager(cacheManager);
        shiroCacheManager.setCacheManagerConfigFile(properties.getCacheManagerConfigFile());
        return shiroCacheManager;
    }
}

