/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.cache;

import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.spring.boot.cache.ShiroEhCache3CacheProperties;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.ehcache.integrations.shiro.EhcacheShiroManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AbstractCachingConfiguration.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@ConditionalOnClass(value={org.ehcache.CacheManager.class})
@ConditionalOnProperty(prefix="shiro.cache", value={"type"}, havingValue="ehcache3")
@EnableConfigurationProperties(value={ShiroEhCache3CacheProperties.class})
public class ShiroEhCache3CacheConfiguration {
    @Bean
    public CacheManager shiroCacheManager(ShiroEhCache3CacheProperties properties, @Autowired(required=false) org.ehcache.CacheManager cacheManager) {
        EhcacheShiroManager shiroCacheManager = new EhcacheShiroManager();
        shiroCacheManager.setCacheManager(cacheManager);
        shiroCacheManager.setCacheManagerConfigFile(properties.getCacheManagerConfigFile());
        return shiroCacheManager;
    }
}

