/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.cache;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.hazelcast.cache.HazelcastCacheManager;
import org.apache.shiro.spring.boot.cache.ShiroHazelcastCacheProperties;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AbstractCachingConfiguration.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@ConditionalOnClass(value={Hazelcast.class, Config.class})
@ConditionalOnProperty(prefix="shiro.cache", value={"type"}, havingValue="spring")
@EnableConfigurationProperties(value={ShiroHazelcastCacheProperties.class})
public class ShiroHazelcastCacheConfiguration {
    @Bean
    public CacheManager shiroCacheManager(ShiroHazelcastCacheProperties config) {
        HazelcastCacheManager cacheManager = new HazelcastCacheManager();
        cacheManager.setConfig((Config)config);
        return cacheManager;
    }
}

