/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.cache;

import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.J2Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.j2cache.J2CacheManager;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AbstractCachingConfiguration.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@ConditionalOnClass(value={J2Cache.class})
@ConditionalOnProperty(prefix="shiro.cache", value={"type"}, havingValue="j2cache")
public class ShiroJ2CacheCacheConfiguration {
    @Bean
    @ConditionalOnBean(value={CacheChannel.class})
    public CacheManager shiroCacheManager(CacheChannel channel) {
        return new J2CacheManager(channel);
    }
}

