/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.cache;

import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.spring.boot.cache.ShiroRedisCacheProperties;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AbstractCachingConfiguration.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@ConditionalOnBean(value={IRedisManager.class})
@ConditionalOnProperty(prefix="shiro.cache", value={"type"}, havingValue="redis")
@EnableConfigurationProperties(value={ShiroRedisCacheProperties.class})
public class ShiroRedisCacheConfiguration {
    @Bean
    public CacheManager shiroCacheManager(ShiroRedisCacheProperties properties, IRedisManager redisManager) {
        RedisCacheManager cacheManager = new RedisCacheManager();
        cacheManager.setExpire(properties.getExpire());
        cacheManager.setKeyPrefix(properties.getKeyPrefix());
        cacheManager.setPrincipalIdFieldName(properties.getPrincipalIdFieldName());
        cacheManager.setRedisManager(redisManager);
        return cacheManager;
    }
}

