/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.cache;

import org.apache.shiro.biz.cache.spring.SpringCacheManager;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.AbstractCachingConfiguration;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AbstractCachingConfiguration.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class})
@ConditionalOnProperty(prefix="shiro.cache", value={"type"}, havingValue="spring")
public class ShiroSpringCacheConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Bean
    public CacheManager shiroCacheManager() {
        org.springframework.cache.CacheManager springCacheManager = (org.springframework.cache.CacheManager)this.getApplicationContext().getBean(org.springframework.cache.CacheManager.class);
        if (null != springCacheManager && springCacheManager instanceof EhCacheCacheManager) {
            EhCacheManager ehCacheManager = new EhCacheManager();
            ehCacheManager.setCacheManager(((EhCacheCacheManager)springCacheManager).getCacheManager());
            return ehCacheManager;
        }
        return new SpringCacheManager(springCacheManager);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

