/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.captcha;

import com.google.code.kaptcha.spring.boot.ext.KaptchaResolver;
import com.google.code.kaptcha.spring.boot.ext.exception.CaptchaIncorrectException;
import com.google.code.kaptcha.spring.boot.ext.exception.CaptchaTimeoutException;
import com.google.code.kaptcha.util.Config;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.biz.authc.exception.IncorrectCaptchaException;
import org.apache.shiro.biz.authc.exception.InvalidCaptchaException;
import org.apache.shiro.biz.authc.token.CaptchaAuthenticationToken;
import org.apache.shiro.biz.web.filter.authc.captcha.CaptchaResolver;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.web.util.WebUtils;

public class ShiroKaptchaCacheResolver
implements KaptchaResolver,
CaptchaResolver {
    public static final String CAPTCHA_SESSION_ATTRIBUTE_NAME = ShiroKaptchaCacheResolver.class.getName() + ".Captcha";
    public static final String CAPTCHA_DATE_SESSION_ATTRIBUTE_NAME = ShiroKaptchaCacheResolver.class.getName() + ".Captcha_DATE";
    private String captchaStoreKey = CAPTCHA_SESSION_ATTRIBUTE_NAME;
    private String captchaDateStoreKey = CAPTCHA_SESSION_ATTRIBUTE_NAME;
    private long captchaTimeout = 60000L;
    private final Cache<String, Object> captchaCache;

    public ShiroKaptchaCacheResolver(Cache<String, Object> captchaCache) {
        this.captchaCache = captchaCache;
    }

    public void init(Config config) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.captchaStoreKey})) {
            this.captchaStoreKey = config.getSessionKey();
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.captchaDateStoreKey})) {
            this.captchaDateStoreKey = config.getSessionDate();
        }
    }

    public void init(String captchaStoreKey, String captchaDateStoreKey, long captchaTimeout) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{captchaStoreKey})) {
            this.captchaStoreKey = captchaStoreKey;
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{captchaDateStoreKey})) {
            this.captchaDateStoreKey = captchaDateStoreKey;
        }
        if (captchaTimeout > 0L) {
            this.captchaTimeout = captchaTimeout;
        }
    }

    public boolean validCaptcha(ServletRequest request, CaptchaAuthenticationToken token) throws AuthenticationException {
        if (StringUtils.isEmpty((CharSequence)token.getCaptcha())) {
            throw new IncorrectCaptchaException();
        }
        try {
            return this.validCaptcha(WebUtils.toHttp((ServletRequest)request), token.getCaptcha());
        }
        catch (CaptchaIncorrectException e) {
            throw new IncorrectCaptchaException((Throwable)e);
        }
        catch (CaptchaTimeoutException e) {
            throw new InvalidCaptchaException((Throwable)e);
        }
    }

    public boolean validCaptcha(HttpServletRequest request, String capText) throws CaptchaIncorrectException, CaptchaTimeoutException {
        if (StringUtils.isEmpty((CharSequence)capText)) {
            throw new CaptchaIncorrectException();
        }
        String sessionCapText = (String)this.getCaptchaCache().get((Object)this.getCaptchaStoreKey());
        if (StringUtils.isEmpty((CharSequence)sessionCapText)) {
            throw new CaptchaIncorrectException();
        }
        Date sessionCapDate = (Date)this.getCaptchaCache().get((Object)this.getCaptchaDateStoreKey());
        if (new Date().getTime() - sessionCapDate.getTime() > this.getCaptchaTimeout()) {
            throw new CaptchaTimeoutException();
        }
        return StringUtils.equalsIgnoreCase((CharSequence)sessionCapText, (CharSequence)capText);
    }

    public void setCaptcha(HttpServletRequest request, HttpServletResponse response, String capText, Date capDate) {
        this.getCaptchaCache().put((Object)this.getCaptchaStoreKey(), (Object)(StringUtils.isNotEmpty((CharSequence)capText) ? capText : null));
        this.getCaptchaCache().put((Object)this.getCaptchaDateStoreKey(), (Object)(capDate != null ? capDate : new Date()));
    }

    public String getCaptchaStoreKey() {
        return this.captchaStoreKey;
    }

    public String getCaptchaDateStoreKey() {
        return this.captchaDateStoreKey;
    }

    public long getCaptchaTimeout() {
        return this.captchaTimeout;
    }

    public Cache<String, Object> getCaptchaCache() {
        return this.captchaCache;
    }
}

