/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.captcha;

import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.biz.authc.exception.IncorrectCaptchaException;
import org.apache.shiro.biz.authc.exception.InvalidCaptchaException;
import org.apache.shiro.biz.authc.token.CaptchaAuthenticationToken;
import org.apache.shiro.biz.utils.WebUtils;
import org.apache.shiro.biz.web.filter.authc.captcha.CaptchaResolver;

public class ShiroSmartCaptchaCaptchaResolver
implements CaptchaResolver {
    public boolean validCaptcha(ServletRequest request, CaptchaAuthenticationToken token) throws AuthenticationException {
        if (StringUtils.isEmpty((CharSequence)token.getCaptcha())) {
            throw new IncorrectCaptchaException();
        }
        try {
            String captcha = (String)WebUtils.toHttp((ServletRequest)request).getSession().getAttribute("CAPTCHA");
            if (captcha == null) {
                throw new InvalidCaptchaException();
            }
            return StringUtils.equalsIgnoreCase((CharSequence)captcha, (CharSequence)token.getCaptcha());
        }
        catch (Exception e) {
            throw new IncorrectCaptchaException((Throwable)e);
        }
    }
}

