/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot;

import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.spring.boot.ShiroBizProperties;
import org.apache.shiro.spring.boot.ShiroJwtProperties;
import org.apache.shiro.spring.boot.jwt.authc.JwtSubjectFactory;
import org.apache.shiro.spring.web.config.AbstractShiroWebConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(name={"org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration", "org.apache.shiro.spring.boot.ShiroBizWebAutoConfiguration"})
@ConditionalOnProperty(prefix="shiro.jwt", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ShiroBizProperties.class, ShiroJwtProperties.class})
public class ShiroJwtWebAutoConfiguration
extends AbstractShiroWebConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private ShiroBizProperties bizProperties;

    @Bean
    protected SubjectFactory subjectFactory() {
        return new JwtSubjectFactory(this.bizProperties.isSessionCreationEnabled());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

