/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot;

import javax.servlet.Filter;
import org.apache.shiro.spring.boot.ShiroBizProperties;
import org.apache.shiro.spring.boot.ShiroJwtProperties;
import org.apache.shiro.spring.boot.biz.ShiroBizFilterFactoryBean;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.spring.web.config.AbstractShiroWebFilterConfiguration;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(name={"org.apache.shiro.spring.config.web.autoconfigure.ShiroWebFilterConfiguration", "org.apache.shiro.spring.boot.ShiroBizWebFilterConfiguration"})
@ConditionalOnProperty(prefix="shiro.jwt", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ShiroBizProperties.class, ShiroJwtProperties.class})
public class ShiroJwtWebFilterConfiguration
extends AbstractShiroWebFilterConfiguration {
    @Autowired
    private ShiroBizProperties properties;

    @Bean
    @ConditionalOnMissingBean
    protected ShiroFilterFactoryBean shiroFilterFactoryBean() {
        ShiroBizFilterFactoryBean filterFactoryBean = new ShiroBizFilterFactoryBean();
        filterFactoryBean.setSuccessUrl(this.properties.getSuccessUrl());
        filterFactoryBean.setUnauthorizedUrl(this.properties.getUnauthorizedUrl());
        filterFactoryBean.setSecurityManager(this.securityManager);
        filterFactoryBean.setFilterChainDefinitionMap(this.shiroFilterChainDefinition.getFilterChainMap());
        return filterFactoryBean;
    }

    @Bean(name={"filterShiroFilterRegistrationBean"})
    @ConditionalOnMissingBean
    protected FilterRegistrationBean<AbstractShiroFilter> filterShiroFilterRegistrationBean() throws Exception {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)((AbstractShiroFilter)this.shiroFilterFactoryBean().getObject()));
        filterRegistrationBean.setOrder(Integer.MAX_VALUE);
        return filterRegistrationBean;
    }
}

