/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.jwt;

import com.github.vindell.jwt.JwtPayload;
import com.google.common.collect.Sets;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.biz.authz.principal.ShiroPrincipalRepositoryImpl;
import org.apache.shiro.spring.boot.jwt.JwtPayloadPrincipal;
import org.apache.shiro.spring.boot.jwt.JwtPayloadRepository;
import org.apache.shiro.spring.boot.jwt.token.JwtAccessToken;

public class JwtPrincipalRepository
extends ShiroPrincipalRepositoryImpl {
    private final JwtPayloadRepository jwtPayloadRepository;
    private boolean checkExpiry = false;

    public JwtPrincipalRepository(JwtPayloadRepository jwtPayloadRepository) {
        this.jwtPayloadRepository = jwtPayloadRepository;
    }

    public AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        JwtAccessToken jwtToken = (JwtAccessToken)token;
        JwtPayload payload = this.getJwtPayloadRepository().getPayload(jwtToken, this.isCheckExpiry());
        JwtPayloadPrincipal principal = new JwtPayloadPrincipal(payload);
        principal.setUserid(payload.getClientId());
        principal.setUserkey(payload.getClientId());
        principal.setRoles(Sets.newHashSet((Iterable)payload.getRoles()));
        principal.setPerms(Sets.newHashSet((Iterable)payload.getPerms()));
        return new SimpleAuthenticationInfo((Object)principal, jwtToken.getCredentials(), "JWT");
    }

    public JwtPayloadRepository getJwtPayloadRepository() {
        return this.jwtPayloadRepository;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }
}

