/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.boot.jwt.authc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.biz.authc.AuthenticationSuccessHandler;
import org.apache.shiro.biz.authz.principal.ShiroPrincipal;
import org.apache.shiro.biz.utils.SubjectUtils;
import org.apache.shiro.biz.utils.WebUtils;
import org.apache.shiro.spring.boot.jwt.JwtPayloadRepository;
import org.apache.shiro.spring.boot.jwt.token.JwtLoginToken;
import org.apache.shiro.subject.Subject;

public class JwtAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private JwtPayloadRepository jwtPayloadRepository;
    private boolean checkExpiry = false;

    public JwtAuthenticationSuccessHandler() {
    }

    public JwtAuthenticationSuccessHandler(JwtPayloadRepository jwtPayloadRepository, boolean checkExpiry) {
        this.jwtPayloadRepository = jwtPayloadRepository;
        this.checkExpiry = checkExpiry;
    }

    public boolean supports(AuthenticationToken token) {
        return SubjectUtils.isAssignableFrom(token.getClass(), (Class[])new Class[]{JwtLoginToken.class});
    }

    public void onAuthenticationSuccess(AuthenticationToken token, ServletRequest request, ServletResponse response, Subject subject) {
        try {
            HashMap<String, Object> tokenMap = new HashMap<String, Object>();
            tokenMap.put("code", "0");
            tokenMap.put("message", "Authentication Success.");
            tokenMap.put("status", "success");
            HashMap<String, Object> principalMap = new HashMap<String, Object>();
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            principalMap.put("initial", ((ShiroPrincipal)subject.getPrincipal()).isInitial());
            String jwt = this.getJwtPayloadRepository().issueJwt(token, subject, request, response);
            principalMap.put("token", jwt);
            principalMap.put("userid", principal.getUserid());
            principalMap.put("userkey", principal.getUserkey());
            principalMap.put("username", principal.getUsername());
            principalMap.put("perms", principal.getPerms());
            principalMap.put("roles", principal.getRoles());
            tokenMap.put("principal", principalMap);
            WebUtils.toHttp((ServletResponse)response).setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            JSONObject.writeJSONString((Writer)response.getWriter(), tokenMap, (SerializerFeature[])new SerializerFeature[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JwtPayloadRepository getJwtPayloadRepository() {
        return this.jwtPayloadRepository;
    }

    public void setJwtPayloadRepository(JwtPayloadRepository jwtPayloadRepository) {
        this.jwtPayloadRepository = jwtPayloadRepository;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }
}

